/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.http;

import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.config.InsightsConfiguration;
import com.redhat.insights.logging.InsightsLogger;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BackoffWrapper {
    private final InsightsLogger logger;
    private final long initialDelay;
    private final double factor;
    private final int max;
    private final Action action;

    BackoffWrapper(InsightsLogger logger2, long initialDelay, double factor, int max, Action action) {
        this.logger = logger2;
        this.initialDelay = initialDelay;
        this.factor = factor;
        this.max = max;
        this.action = action;
    }

    public BackoffWrapper(InsightsLogger logger2, InsightsConfiguration configuration, Action action) {
        this(logger2, configuration.getHttpClientRetryInitialDelay(), configuration.getHttpClientRetryBackoffFactor(), configuration.getHttpClientRetryMaxAttempts(), action);
    }

    public int run() {
        double delay = this.initialDelay;
        int count = 0;
        Throwable retryFailure = null;
        while (true) {
            try {
                this.action.run();
                return count;
            }
            catch (Throwable err) {
                if (retryFailure == null) {
                    retryFailure = new InsightsException(InsightsErrorCode.ERROR_CLIENT_BACKOFF_RETRIES_FAILED, "Exponential backoff retries have failed");
                }
                retryFailure.addSuppressed(err);
                this.logger.debug("Backoff #" + (count + 1) + "/" + this.max + ", sleeping " + delay + "ms", err);
                try {
                    Thread.sleep((long)delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InsightsException(InsightsErrorCode.ERROR_INTERRUPTED_THREAD, "HTTP sending thread interrupted", e);
                }
                if (++count == this.max) {
                    throw retryFailure;
                }
                delay *= this.factor;
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void run() throws Throwable;
    }
}

