/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.tls;

import com.redhat.insights.agent.shaded.InsightsErrorCode;
import com.redhat.insights.agent.shaded.InsightsException;
import com.redhat.insights.agent.shaded.config.InsightsConfiguration;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.CodePointIterator;
import com.redhat.insights.agent.shaded.org.wildfly.security.pem.Pem;
import com.redhat.insights.agent.shaded.tls.CertHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class PEMSupport {
    private final InsightsLogger logger;
    private final InsightsConfiguration configuration;

    public PEMSupport(InsightsLogger logger2, InsightsConfiguration configuration) {
        this.logger = logger2;
        this.configuration = configuration;
    }

    public SSLContext createTLSContext() {
        if (!this.configuration.useMTLS()) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "Illegal attempt to create SSLContext for token auth");
        }
        byte[] certBytes = this.getBytesPossiblyPrivileged("--cert");
        byte[] keyBytes = this.getBytesPossiblyPrivileged("--key");
        if (certBytes.length == 0 || keyBytes.length == 0) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_READING_CERTS, "SSLContext creation error - could not get file bytes");
        }
        this.logger.debug("Cert and key obtained successfully, trying to create TLS context");
        return this.createTLSContext(certBytes, keyBytes);
    }

    public SSLContext createTLSContext(Path certificatePath, Path keyPath) {
        if (!Files.exists(certificatePath, new LinkOption[0])) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "The certificate file does not exist: " + certificatePath);
        }
        if (!Files.exists(keyPath, new LinkOption[0])) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "The key file does not exist: " + certificatePath);
        }
        try {
            byte[] certBytes = Files.readAllBytes(certificatePath);
            byte[] keyBytes = Files.readAllBytes(keyPath);
            return this.createTLSContext(certBytes, keyBytes);
        }
        catch (Exception err) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "SSLContext creation error", err);
        }
    }

    byte[] getBytesPossiblyPrivileged(String mode) {
        String pathStr = "";
        switch (mode) {
            case "--cert": {
                pathStr = this.configuration.getCertFilePath();
                break;
            }
            case "--key": {
                pathStr = this.configuration.getKeyFilePath();
                break;
            }
            default: {
                throw new InsightsException(InsightsErrorCode.ERROR_SSL_READING_CERTS_INVALID_MODE, "Invalid mode " + mode + " passed for cert retrieval. This should not happen.");
            }
        }
        try {
            return Files.readAllBytes(Paths.get(pathStr, new String[0]));
        }
        catch (IOException iox) {
            this.logger.debug("Direct read of cert and key failed.", iox);
            this.logger.debug("Trying to use the helper binary " + this.configuration.getCertHelperBinary() + " to read default cert: " + "/etc/pki/consumer/cert.pem" + " and key: " + "/etc/pki/consumer/key.pem");
            CertHelper helper = new CertHelper(this.logger, this.configuration);
            try {
                return helper.readUsingHelper(mode);
            }
            catch (IOException | InterruptedException e) {
                throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "SSLContext creation error", e);
            }
        }
    }

    SSLContext createTLSContext(byte[] certPemData, byte[] keyPemData) {
        char[] keystorePassword = new char[]{};
        try {
            int i;
            Certificate[] certificates = PEMSupport.parsePemData(Certificate.class, certPemData).toArray(new Certificate[0]);
            List<PrivateKey> keys = PEMSupport.parsePemData(PrivateKey.class, keyPemData);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            for (i = 0; i < certificates.length; ++i) {
                keyStore.setCertificateEntry("cert-" + i, certificates[i]);
            }
            for (i = 0; i < keys.size(); ++i) {
                keyStore.setKeyEntry("key-" + i, keys.get(i), keystorePassword, certificates);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keystorePassword);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            return sslContext;
        }
        catch (CertificateException err) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CERTS_PROBLEM, "Certificates error", err);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException err) {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "SSLContext creation error", err);
        }
    }

    private static <T> List<T> parsePemData(Class<T> type, byte[] data) {
        ArrayList items = new ArrayList();
        Pem.parsePemContent(CodePointIterator.ofUtf8Bytes(data)).forEachRemaining(pemEntry -> {
            Object cast = pemEntry.tryCast(type);
            if (cast == null) {
                throw new InsightsException(InsightsErrorCode.ERROR_SSL_PARSING_CERTS, "Could not cast the a PemEntry of type " + type + " to class " + type);
            }
            items.add(cast);
        });
        return items;
    }
}

