/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.tls;

import com.redhat.insights.agent.shaded.config.InsightsConfiguration;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.tls.CertStreamHandler;
import com.redhat.insights.agent.shaded.tls.InsightsHelperStatus;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CertHelper {
    private final InsightsLogger logger;
    private final InsightsConfiguration configuration;

    public CertHelper(InsightsLogger logger2, InsightsConfiguration configuration) {
        this.logger = logger2;
        this.configuration = configuration;
    }

    public byte[] readUsingHelper(String mode) throws IOException, InterruptedException {
        String certHelperBinaryPath = this.configuration.getCertHelperBinary();
        if (!new File(certHelperBinaryPath).exists()) {
            throw new IOException("Cert helper binary: " + certHelperBinaryPath + " does not exists.");
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(certHelperBinaryPath, mode);
        builder.directory(new File(System.getProperty("user.home")));
        Process process = builder.start();
        StringBuilder sb = new StringBuilder();
        CertStreamHandler handler = new CertStreamHandler(process.getInputStream(), l -> sb.append((String)l));
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<?> future = service.submit(handler);
        InsightsHelperStatus exitCode = InsightsHelperStatus.fromExitCode(process.waitFor());
        service.shutdown();
        try {
            future.get();
        }
        catch (ExecutionException e) {
            throw new IOException("Helper subprocess execution failed", e);
        }
        if (InsightsHelperStatus.OK.equals((Object)exitCode)) {
            return sb.toString().getBytes(StandardCharsets.UTF_8);
        }
        String msg = "Couldn't use helper. Sub-process returned: " + exitCode.getCode() + " ; " + exitCode.getMessage();
        throw new IOException(msg);
    }
}

