/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.reports;

import com.redhat.insights.agent.shaded.Filtering;
import com.redhat.insights.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.redhat.insights.agent.shaded.jars.JarInfo;
import com.redhat.insights.agent.shaded.jars.JarInfoSubreport;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.reports.InsightsReport;
import com.redhat.insights.agent.shaded.reports.InsightsReportSerializer;
import com.redhat.insights.agent.shaded.reports.InsightsSubreport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;

public class UpdateReportImpl
implements InsightsReport {
    private String idHash = "";
    private final BlockingQueue<JarInfo> updatedJars;
    private final InsightsLogger logger;
    private Optional<JarInfoSubreport> subreport = Optional.empty();
    private final InsightsReportSerializer serializer;

    public UpdateReportImpl(BlockingQueue<JarInfo> updatedJars, InsightsLogger logger2) {
        this.updatedJars = updatedJars;
        this.logger = logger2;
        this.serializer = new InsightsReportSerializer();
    }

    @Override
    public Map<String, InsightsSubreport> getSubreports() {
        if (!this.subreport.isPresent()) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("updated-jars", (InsightsSubreport)this.subreport.get());
    }

    @Override
    public JsonSerializer<InsightsReport> getSerializer() {
        return this.serializer;
    }

    @Override
    public void generateReport(Filtering __) {
        if (!this.updatedJars.isEmpty()) {
            ArrayList<JarInfo> jars = new ArrayList<JarInfo>();
            int sendCount = this.updatedJars.drainTo(jars);
            JarInfoSubreport jarInfoSubreport = new JarInfoSubreport(this.logger, jars);
            jarInfoSubreport.generateReport();
            this.subreport = Optional.of(jarInfoSubreport);
            this.logger.debug("Sending " + sendCount + " jars from " + this.getIdHash());
        }
    }

    @Override
    public Map<String, Object> getBasic() {
        return Collections.emptyMap();
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public void setIdHash(String idHash) {
        this.idHash = idHash;
    }

    @Override
    public String getIdHash() {
        return this.idHash;
    }

    @Override
    public void decorate(String key, String value) {
        this.logger.debug(String.format("Attempt to add %s => %s to an update report. Ignored.", key, value));
    }

    @Override
    public void close() throws IOException {
    }
}

