/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert._private;

import com.redhat.insights.agent.shaded.org.jboss.logging.BasicLogger;
import com.redhat.insights.agent.shaded.org.jboss.logging.DelegatingBasicLogger;
import com.redhat.insights.agent.shaded.org.jboss.logging.Logger;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Exception;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert._private.ElytronMessages;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Locale;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String malformedPemContent$str() {
        return "ELY03010: Malformed PEM content at offset %d";
    }

    @Override
    public final IllegalArgumentException malformedPemContent(long offset) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.malformedPemContent$str(), offset));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidPemType$str() {
        return "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    }

    @Override
    public final IllegalArgumentException invalidPemType(String expected, String actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPemType$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateParseError$str() {
        return "ELY03012: Certificate parse error";
    }

    @Override
    public final IllegalArgumentException certificateParseError(CertificateException cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateParseError$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String publicKeyParseError$str() {
        return "ELY03023: PublicKey parse error";
    }

    @Override
    public final IllegalArgumentException publicKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyParseError$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String privateKeyParseError$str() {
        return "ELY03033: PrivateKey parse error";
    }

    @Override
    public final IllegalArgumentException privateKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyParseError$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnUnrecognisedAlgorithm$str() {
        return "ELY07001: Unrecognized encoding algorithm [%s]";
    }

    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(String algorithm) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnrecognisedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnUnexpectedTag$str() {
        return "ELY07004: Unexpected ASN.1 tag encountered";
    }

    @Override
    public final ASN1Exception asnUnexpectedTag() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnexpectedTag$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String extensionAlreadyExists$str() {
        return "ELY10000: X.509 certificate extension with OID %s already exists";
    }

    @Override
    public final IllegalArgumentException extensionAlreadyExists(String oid) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.extensionAlreadyExists$str(), oid));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSignatureAlgorithmNameGiven$str() {
        return "ELY10001: No signature algorithm name given";
    }

    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSignatureAlgorithmNameGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownSignatureAlgorithmName$str() {
        return "ELY10002: Signature algorithm name \"%s\" is not recognized";
    }

    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(String signatureAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSigningKeyGiven$str() {
        return "ELY10003: No signing key given";
    }

    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSigningKeyGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signingKeyNotCompatWithSig$str() {
        return "ELY10004: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    }

    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(String signingKeyAlgorithm, String signatureAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validAfterBeforeValidBefore$str() {
        return "ELY10005: Not-valid-before date of %s is after not-valid-after date of %s";
    }

    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(ZonedDateTime notValidBefore, ZonedDateTime notValidAfter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noIssuerDnGiven$str() {
        return "ELY10006: No issuer DN given";
    }

    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noIssuerDnGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noPublicKeyGiven$str() {
        return "ELY10007: No public key given";
    }

    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noPublicKeyGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String uniqueIdNotAllowed$str() {
        return "ELY10008: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    }

    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.uniqueIdNotAllowed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String extensionsNotAllowed$str() {
        return "ELY10009: Extensions are only allowed in certificates with version 3 or higher";
    }

    @Override
    public final IllegalArgumentException extensionsNotAllowed() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.extensionsNotAllowed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeyForCert$str() {
        return "ELY10010: X.509 encoding of public key with algorithm \"%s\" failed";
    }

    @Override
    public final IllegalArgumentException invalidKeyForCert(String publicKeyAlgorithm, Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certSigningFailed$str() {
        return "ELY10011: Failed to sign certificate";
    }

    @Override
    public final IllegalArgumentException certSigningFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certSigningFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serialNumberTooSmall$str() {
        return "ELY10012: Certificate serial number must be positive";
    }

    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.serialNumberTooSmall$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serialNumberTooLarge$str() {
        return "ELY10013: Certificate serial number too large (cannot exceed 20 octets)";
    }

    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.serialNumberTooLarge$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certRequestInfoSigningFailed$str() {
        return "ELY10014: Failed to sign certification request info";
    }

    @Override
    public final IllegalArgumentException certRequestInfoSigningFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certRequestInfoSigningFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCertificateGiven$str() {
        return "ELY10015: No certificate given";
    }

    @Override
    public final IllegalArgumentException noCertificateGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noCertificateGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDnGiven$str() {
        return "ELY10017: No DN given";
    }

    @Override
    public final IllegalArgumentException noDnGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noDnGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String selfSignedCertificateGenerationFailed$str() {
        return "ELY10018: Failed to generate self-signed X.509 certificate";
    }

    @Override
    public final IllegalArgumentException selfSignedCertificateGenerationFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.selfSignedCertificateGenerationFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    }

    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String keyAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateExtensionCreationFromStringNotSupported$str() {
        return "ELY10020: Creating an X.509 certificate extension from a string value is not supported for extension name \"%s\"";
    }

    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringNotSupported(String extensionName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateExtensionCreationFromStringNotSupported$str(), extensionName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCertificateExtensionStringValue1$str() {
        return "ELY10021: Invalid X.509 certificate extension string value \"%s\"";
    }

    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue(String extensionValue) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCertificateExtensionStringValue1$str(), extensionValue));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateExtensionCreationFromStringFailed$str() {
        return "ELY10022: Failed to create X.509 certificate extension from string value";
    }

    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateExtensionCreationFromStringFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateExtensionMustBeNonCritical$str() {
        return "ELY10023: X.509 certificate extension \"%s\" must be non-critical";
    }

    @Override
    public final IllegalArgumentException certificateExtensionMustBeNonCritical(String extensionName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateExtensionMustBeNonCritical$str(), extensionName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCertificateExtensionStringValue0$str() {
        return "ELY10024: Invalid X.509 certificate extension string value";
    }

    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCertificateExtensionStringValue0$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

