/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.DEREncoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert._private.ElytronMessages;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public final class X509CertificateBuilder {
    private static final ZonedDateTime LATEST_VALID = ZonedDateTime.of(9999, 12, 31, 23, 59, 59, 0, ZoneOffset.UTC);
    private int version = 3;
    private BigInteger serialNumber = BigInteger.ONE;
    private X500Principal subjectDn;
    private byte[] subjectUniqueId;
    private X500Principal issuerDn;
    private byte[] issuerUniqueId;
    private ZonedDateTime notValidBefore = ZonedDateTime.now();
    private ZonedDateTime notValidAfter = LATEST_VALID;
    private final Map<String, X509CertificateExtension> extensionsByOid = new LinkedHashMap<String, X509CertificateExtension>();
    private PublicKey publicKey;
    private PrivateKey signingKey;
    private String signatureAlgorithmName;

    public X509CertificateBuilder addExtension(X509CertificateExtension extension) {
        Assert.checkNotNullParam("extension", extension);
        String oid = extension.getId();
        Assert.checkNotNullParam("extension.getOid()", oid);
        if (this.extensionsByOid.putIfAbsent(oid, extension) != null) {
            throw ElytronMessages.log.extensionAlreadyExists(oid);
        }
        return this;
    }

    public X509CertificateExtension addOrReplaceExtension(X509CertificateExtension extension) {
        Assert.checkNotNullParam("extension", extension);
        String oid = extension.getId();
        Assert.checkNotNullParam("extension.getOid()", oid);
        return this.extensionsByOid.put(oid, extension);
    }

    public X509CertificateExtension removeExtension(String oid) {
        Assert.checkNotNullParam("oid", oid);
        return this.extensionsByOid.remove(oid);
    }

    public int getVersion() {
        return this.version;
    }

    public X509CertificateBuilder setVersion(int version) {
        Assert.checkMinimumParameter("version", 1, version);
        Assert.checkMaximumParameter("version", 3, version);
        this.version = version;
        return this;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X509CertificateBuilder setSerialNumber(BigInteger serialNumber) {
        Assert.checkNotNullParam("serialNumber", serialNumber);
        if (BigInteger.ONE.compareTo(serialNumber) > 0) {
            throw ElytronMessages.log.serialNumberTooSmall();
        }
        if (serialNumber.bitLength() > 160) {
            throw ElytronMessages.log.serialNumberTooLarge();
        }
        this.serialNumber = serialNumber;
        return this;
    }

    public X500Principal getSubjectDn() {
        return this.subjectDn;
    }

    public X509CertificateBuilder setSubjectDn(X500Principal subjectDn) {
        Assert.checkNotNullParam("subjectDn", subjectDn);
        this.subjectDn = subjectDn;
        return this;
    }

    public byte[] getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public X509CertificateBuilder setSubjectUniqueId(byte[] subjectUniqueId) {
        Assert.checkNotNullParam("subjectUniqueId", subjectUniqueId);
        this.subjectUniqueId = subjectUniqueId;
        return this;
    }

    public X500Principal getIssuerDn() {
        return this.issuerDn;
    }

    public X509CertificateBuilder setIssuerDn(X500Principal issuerDn) {
        Assert.checkNotNullParam("issuerDn", issuerDn);
        this.issuerDn = issuerDn;
        return this;
    }

    public byte[] getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public X509CertificateBuilder setIssuerUniqueId(byte[] issuerUniqueId) {
        Assert.checkNotNullParam("issuerUniqueId", issuerUniqueId);
        this.issuerUniqueId = issuerUniqueId;
        return this;
    }

    public ZonedDateTime getNotValidBefore() {
        return this.notValidBefore;
    }

    public X509CertificateBuilder setNotValidBefore(ZonedDateTime notValidBefore) {
        Assert.checkNotNullParam("notValidBefore", notValidBefore);
        this.notValidBefore = notValidBefore;
        return this;
    }

    public ZonedDateTime getNotValidAfter() {
        return this.notValidAfter;
    }

    public X509CertificateBuilder setNotValidAfter(ZonedDateTime notValidAfter) {
        Assert.checkNotNullParam("notValidAfter", notValidAfter);
        this.notValidAfter = notValidAfter;
        return this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509CertificateBuilder setPublicKey(PublicKey publicKey) {
        Assert.checkNotNullParam("publicKey", publicKey);
        this.publicKey = publicKey;
        return this;
    }

    public PrivateKey getSigningKey() {
        return this.signingKey;
    }

    public X509CertificateBuilder setSigningKey(PrivateKey signingKey) {
        Assert.checkNotNullParam("signingKey", signingKey);
        this.signingKey = signingKey;
        return this;
    }

    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    public X509CertificateBuilder setSignatureAlgorithmName(String signatureAlgorithmName) {
        Assert.checkNotNullParam("signatureAlgorithmName", signatureAlgorithmName);
        this.signatureAlgorithmName = signatureAlgorithmName;
        return this;
    }

    public X509Certificate build() throws CertificateException {
        byte[] tbsCertificate = this.getTBSBytes();
        DEREncoder derEncoder = new DEREncoder();
        derEncoder.startSequence();
        derEncoder.writeEncoded(tbsCertificate);
        String signatureAlgorithmName = this.signatureAlgorithmName;
        String signatureAlgorithmOid = ASN1.oidFromSignatureAlgorithm(signatureAlgorithmName);
        if (signatureAlgorithmOid == null) {
            throw ElytronMessages.log.asnUnrecognisedAlgorithm(signatureAlgorithmName);
        }
        derEncoder.startSequence();
        derEncoder.encodeObjectIdentifier(signatureAlgorithmOid);
        derEncoder.endSequence();
        try {
            Signature signature = Signature.getInstance(signatureAlgorithmName);
            signature.initSign(this.signingKey);
            signature.update(tbsCertificate);
            derEncoder.encodeBitString(signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw ElytronMessages.log.certSigningFailed(e);
        }
        derEncoder.endSequence();
        byte[] bytes = derEncoder.getEncoded();
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
    }

    byte[] getTBSBytes() {
        X509EncodedKeySpec keySpec;
        BigInteger serialNumber = this.serialNumber;
        int version = this.version;
        String signatureAlgorithmName = this.signatureAlgorithmName;
        if (signatureAlgorithmName == null) {
            throw ElytronMessages.log.noSignatureAlgorithmNameGiven();
        }
        String signatureAlgorithmOid = ASN1.oidFromSignatureAlgorithm(signatureAlgorithmName);
        if (signatureAlgorithmOid == null) {
            throw ElytronMessages.log.unknownSignatureAlgorithmName(signatureAlgorithmName);
        }
        PrivateKey signingKey = this.signingKey;
        if (signingKey == null) {
            throw ElytronMessages.log.noSigningKeyGiven();
        }
        String signingKeyAlgorithm = signingKey.getAlgorithm();
        if (signingKeyAlgorithm.equals("EC")) {
            signingKeyAlgorithm = "ECDSA";
        }
        if (!signatureAlgorithmName.endsWith("with" + signingKeyAlgorithm) || signatureAlgorithmName.contains("with" + signingKeyAlgorithm + "and")) {
            throw ElytronMessages.log.signingKeyNotCompatWithSig(signingKey.getAlgorithm(), signatureAlgorithmName);
        }
        ZonedDateTime notValidBefore = this.notValidBefore;
        ZonedDateTime notValidAfter = this.notValidAfter;
        if (notValidBefore.compareTo(notValidAfter) > 0) {
            throw ElytronMessages.log.validAfterBeforeValidBefore(notValidBefore, notValidAfter);
        }
        X500Principal issuerDn = this.issuerDn;
        if (issuerDn == null) {
            throw ElytronMessages.log.noIssuerDnGiven();
        }
        X500Principal subjectDn = this.subjectDn;
        PublicKey publicKey = this.publicKey;
        if (publicKey == null) {
            throw ElytronMessages.log.noPublicKeyGiven();
        }
        byte[] issuerUniqueId = this.issuerUniqueId;
        byte[] subjectUniqueId = this.subjectUniqueId;
        if (version < 2 && (issuerUniqueId != null || subjectUniqueId != null)) {
            throw ElytronMessages.log.uniqueIdNotAllowed();
        }
        Map<String, X509CertificateExtension> extensionsByOid = this.extensionsByOid;
        if (version < 3 && !extensionsByOid.isEmpty()) {
            throw ElytronMessages.log.extensionsNotAllowed();
        }
        DEREncoder derEncoder = new DEREncoder();
        derEncoder.startSequence();
        derEncoder.startExplicit(0);
        derEncoder.encodeInteger(version - 1);
        derEncoder.endExplicit();
        derEncoder.encodeInteger(serialNumber);
        derEncoder.startSequence();
        derEncoder.encodeObjectIdentifier(signatureAlgorithmOid);
        derEncoder.endSequence();
        derEncoder.writeEncoded(issuerDn.getEncoded());
        derEncoder.startSequence();
        derEncoder.encodeGeneralizedTime(notValidBefore.withZoneSameInstant(ZoneOffset.UTC));
        derEncoder.encodeGeneralizedTime(notValidAfter.withZoneSameInstant(ZoneOffset.UTC));
        derEncoder.endSequence();
        if (subjectDn != null) {
            derEncoder.writeEncoded(subjectDn.getEncoded());
        }
        String publicKeyAlgorithm = publicKey.getAlgorithm();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(publicKeyAlgorithm);
            Key translatedKey = keyFactory.translateKey(publicKey);
            keySpec = keyFactory.getKeySpec(translatedKey, X509EncodedKeySpec.class);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw ElytronMessages.log.invalidKeyForCert(publicKeyAlgorithm, e);
        }
        derEncoder.writeEncoded(keySpec.getEncoded());
        if (issuerUniqueId != null) {
            derEncoder.encodeImplicit(1);
            derEncoder.encodeBitString(issuerUniqueId);
        }
        if (subjectUniqueId != null) {
            derEncoder.encodeImplicit(2);
            derEncoder.encodeBitString(subjectUniqueId);
        }
        if (!extensionsByOid.isEmpty()) {
            derEncoder.startExplicit(3);
            derEncoder.startSequence();
            for (X509CertificateExtension extension : extensionsByOid.values()) {
                derEncoder.startSequence();
                derEncoder.encodeObjectIdentifier(extension.getId());
                if (extension.isCritical()) {
                    derEncoder.encodeBoolean(true);
                }
                DEREncoder subEncoder = new DEREncoder();
                extension.encodeTo(subEncoder);
                derEncoder.encodeOctetString(subEncoder.getEncoded());
                derEncoder.endSequence();
            }
            derEncoder.endSequence();
            derEncoder.endExplicit();
        }
        derEncoder.endSequence();
        return derEncoder.getEncoded();
    }
}

