/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.AccessDescription;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.util.List;

public final class SubjectInformationAccessExtension
extends X509CertificateExtension {
    private final List<AccessDescription> accessDescriptions;

    public SubjectInformationAccessExtension(List<AccessDescription> accessDescriptions) {
        super(false);
        Assert.checkNotNullParam("accessDescriptions", accessDescriptions);
        this.accessDescriptions = accessDescriptions;
    }

    @Override
    public String getId() {
        return "1.3.6.1.5.5.7.1.11";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (AccessDescription accessDescription : this.accessDescriptions) {
            accessDescription.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

