/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.X500DirectoryAttribute;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.util.List;

public final class SubjectDirectoryAttributesExtension
extends X509CertificateExtension {
    private final List<X500DirectoryAttribute> directoryAttributes;

    public SubjectDirectoryAttributesExtension(List<X500DirectoryAttribute> directoryAttributes) {
        super(false);
        Assert.checkNotNullParam("directoryAttributes", directoryAttributes);
        this.directoryAttributes = directoryAttributes;
    }

    @Override
    public String getId() {
        return "2.5.29.9";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (X500DirectoryAttribute directoryAttribute : this.directoryAttributes) {
            directoryAttribute.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

