/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encodable;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.util.List;

public final class PolicyMappingsExtension
extends X509CertificateExtension {
    private final List<PolicyMapping> policyMappings;

    public PolicyMappingsExtension(boolean critical, List<PolicyMapping> policyMappings) {
        super(critical);
        Assert.checkNotNullParam("policyMappings", policyMappings);
        this.policyMappings = policyMappings;
    }

    @Override
    public String getId() {
        return "2.5.29.33";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (PolicyMapping policyMapping : this.policyMappings) {
            policyMapping.encodeTo(encoder);
        }
        encoder.endSequence();
    }

    public static final class PolicyMapping
    implements ASN1Encodable {
        private final String issuerDomainPolicyOid;
        private final String subjectDomainPolicyOid;

        public PolicyMapping(String issuerDomainPolicyOid, String subjectDomainPolicyOid) {
            Assert.checkNotNullParam("issuerDomainPolicyOid", issuerDomainPolicyOid);
            Assert.checkNotNullParam("subjectDomainPolicyOid", subjectDomainPolicyOid);
            this.issuerDomainPolicyOid = issuerDomainPolicyOid;
            this.subjectDomainPolicyOid = subjectDomainPolicyOid;
        }

        public String getIssuerDomainPolicyOid() {
            return this.issuerDomainPolicyOid;
        }

        public String getSubjectDomainPolicyOid() {
            return this.subjectDomainPolicyOid;
        }

        @Override
        public void encodeTo(ASN1Encoder encoder) {
            encoder.startSequence();
            encoder.encodeObjectIdentifier(this.issuerDomainPolicyOid);
            encoder.encodeObjectIdentifier(this.subjectDomainPolicyOid);
            encoder.endSequence();
        }
    }
}

