/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encodable;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.GeneralName;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.util.List;

public final class NameConstraintsExtension
extends X509CertificateExtension {
    private final List<GeneralSubtree> permittedSubtrees;
    private final List<GeneralSubtree> excludedSubtrees;

    public NameConstraintsExtension(List<GeneralSubtree> permittedSubtrees, List<GeneralSubtree> excludedSubtrees) {
        super(true);
        Assert.checkNotNullParam("permittedSubtrees", permittedSubtrees);
        Assert.checkNotNullParam("excludedSubtrees", excludedSubtrees);
        this.permittedSubtrees = permittedSubtrees;
        this.excludedSubtrees = excludedSubtrees;
    }

    @Override
    public String getId() {
        return "2.5.29.30";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        if (!this.permittedSubtrees.isEmpty()) {
            encoder.encodeImplicit(0);
            encoder.startSequence();
            for (GeneralSubtree subtree : this.permittedSubtrees) {
                subtree.encodeTo(encoder);
            }
            encoder.endSequence();
        }
        if (!this.excludedSubtrees.isEmpty()) {
            encoder.encodeImplicit(1);
            encoder.startSequence();
            for (GeneralSubtree subtree : this.excludedSubtrees) {
                subtree.encodeTo(encoder);
            }
            encoder.endSequence();
        }
        encoder.endSequence();
    }

    public static final class GeneralSubtree
    implements ASN1Encodable {
        private final GeneralName base;
        private final int minimumDistance;
        private final int maximumDistance;

        public GeneralSubtree(GeneralName base, int minimumDistance, int maximumDistance) {
            this.base = base;
            Assert.checkMinimumParameter("minimumDistance", 0, minimumDistance);
            if (maximumDistance != -1) {
                Assert.checkMinimumParameter("maximumDistance", minimumDistance, maximumDistance);
            }
            this.minimumDistance = minimumDistance;
            this.maximumDistance = maximumDistance;
        }

        @Override
        public void encodeTo(ASN1Encoder encoder) {
            encoder.startSequence();
            this.base.encodeTo(encoder);
            if (this.minimumDistance > 0) {
                encoder.encodeImplicit(0);
                encoder.encodeInteger(this.minimumDistance);
            }
            if (this.maximumDistance >= 0) {
                encoder.encodeImplicit(1);
                encoder.encodeInteger(this.maximumDistance);
            }
        }
    }
}

