/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.GeneralName;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.util.List;

public final class IssuerAlternativeNamesExtension
extends X509CertificateExtension {
    private final List<GeneralName> issuerAlternativeNames;

    public IssuerAlternativeNamesExtension(boolean critical, List<GeneralName> issuerAlternativeNames) {
        super(critical);
        Assert.checkNotNullParam("issuerAlternativeNames", issuerAlternativeNames);
        this.issuerAlternativeNames = issuerAlternativeNames;
    }

    @Override
    public String getId() {
        return "2.5.29.18";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (GeneralName name : this.issuerAlternativeNames) {
            name.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

