/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.util.List;

public final class ExtendedKeyUsageExtension
extends X509CertificateExtension {
    private final List<String> keyPurposeIds;

    public ExtendedKeyUsageExtension(boolean critical, List<String> keyPurposeIds) {
        super(critical);
        Assert.checkNotNullParam("keyPurposeIds", keyPurposeIds);
        Assert.checkNotEmptyParam("keyPurposeIds", keyPurposeIds);
        this.keyPurposeIds = keyPurposeIds;
    }

    @Override
    public String getId() {
        return "2.5.29.37";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (String keyPurposeId : this.keyPurposeIds) {
            encoder.encodeObjectIdentifier(keyPurposeId);
        }
        encoder.endSequence();
    }
}

