/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert;

import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.GeneralName;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.cert.X509CertificateExtension;
import java.math.BigInteger;
import java.util.List;

public final class AuthorityKeyIdentifierExtension
extends X509CertificateExtension {
    private final byte[] keyIdentifier;
    private final List<GeneralName> generalNames;
    private final BigInteger serialNumber;

    public AuthorityKeyIdentifierExtension(byte[] keyIdentifier, List<GeneralName> generalNames, BigInteger serialNumber) {
        super(false);
        this.keyIdentifier = keyIdentifier;
        this.generalNames = generalNames;
        this.serialNumber = serialNumber;
    }

    @Override
    public String getId() {
        return "2.5.29.35";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        if (this.keyIdentifier != null) {
            encoder.encodeImplicit(0);
            encoder.encodeOctetString(this.keyIdentifier);
        }
        if (this.generalNames != null && !this.generalNames.isEmpty()) {
            encoder.encodeImplicit(1);
            encoder.startSequence();
            for (GeneralName generalName : this.generalNames) {
                generalName.encodeTo(encoder);
            }
            encoder.endSequence();
        }
        if (this.serialNumber != null) {
            encoder.encodeImplicit(2);
            encoder.encodeInteger(this.serialNumber);
        }
        encoder.endSequence();
    }
}

