/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.DEREncoder;
import com.redhat.insights.agent.shaded.org.wildfly.security.x500.X500AttributeTypeAndValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public final class X500PrincipalBuilder {
    private final List<Collection<X500AttributeTypeAndValue>> items = new ArrayList<Collection<X500AttributeTypeAndValue>>();

    public X500PrincipalBuilder addItem(X500AttributeTypeAndValue attributeTypeAndValue) {
        Assert.checkNotNullParam("attributeTypeAndValue", attributeTypeAndValue);
        this.items.add(Collections.singletonList(attributeTypeAndValue));
        return this;
    }

    public X500PrincipalBuilder addCompoundItem(Collection<X500AttributeTypeAndValue> attributeTypeAndValues) {
        Assert.checkNotNullParam("attributeTypeAndValues", attributeTypeAndValues);
        Assert.checkNotEmptyParam("attributeTypeAndValues", attributeTypeAndValues);
        this.items.add(attributeTypeAndValues);
        return this;
    }

    public X500Principal build() throws IllegalArgumentException {
        DEREncoder derEncoder = new DEREncoder();
        derEncoder.startSequence();
        for (Collection<X500AttributeTypeAndValue> itemSet : this.items) {
            derEncoder.startSet();
            for (X500AttributeTypeAndValue item : itemSet) {
                item.encodeTo(derEncoder);
            }
            derEncoder.endSet();
        }
        derEncoder.endSequence();
        return new X500Principal(derEncoder.getEncoded());
    }
}

