/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.security.x500;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encodable;
import com.redhat.insights.agent.shaded.org.wildfly.security.asn1.ASN1Encoder;

public final class X500AttributeTypeAndValue
implements ASN1Encodable {
    private final String attributeType;
    private final ASN1Encodable value;

    private X500AttributeTypeAndValue(String attributeType, ASN1Encodable value) {
        this.attributeType = attributeType;
        this.value = value;
    }

    public static X500AttributeTypeAndValue create(String attributeType, ASN1Encodable value) {
        Assert.checkNotNullParam("attributeType", attributeType);
        Assert.checkNotNullParam("value", value);
        return new X500AttributeTypeAndValue(attributeType, value);
    }

    public static X500AttributeTypeAndValue createUtf8(String attributeType, String stringValue) {
        Assert.checkNotNullParam("stringValue", stringValue);
        return X500AttributeTypeAndValue.create(attributeType, ASN1Encodable.ofUtf8String(stringValue));
    }

    public static X500AttributeTypeAndValue createObjectId(String attributeType, String oid) {
        return X500AttributeTypeAndValue.create(attributeType, ASN1Encodable.ofOid(oid));
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        encoder.encodeObjectIdentifier(this.attributeType);
        this.value.encodeTo(encoder);
        encoder.endSequence();
    }
}

