/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.xml;

import com.redhat.insights.agent.shaded.org.wildfly.common.annotation.NotNull;
import com.redhat.insights.agent.shaded.org.wildfly.common.xml.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLInputFactory;

public final class XMLInputFactoryUtil {
    private static final AtomicBoolean TO_BE_LOGGED = new AtomicBoolean(true);

    @NotNull
    public static XMLInputFactory create() {
        XMLInputFactory instance;
        block5: {
            boolean toBeLogged;
            block4: {
                instance = XMLInputFactory.newInstance();
                toBeLogged = TO_BE_LOGGED.compareAndSet(true, false);
                try {
                    instance.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                }
                catch (IllegalArgumentException e) {
                    if (!toBeLogged) break block4;
                    Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "javax.xml.stream.supportDTD", instance.getClass().getCanonicalName());
                }
            }
            try {
                instance.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            }
            catch (IllegalArgumentException e) {
                if (!toBeLogged) break block5;
                Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "javax.xml.stream.isSupportingExternalEntities", instance.getClass().getCanonicalName());
            }
        }
        return instance;
    }

    private XMLInputFactoryUtil() {
        throw new IllegalStateException("No instance");
    }
}

