/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.net;

import com.redhat.insights.agent.shaded.org.wildfly.common.net.HostName;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;

final class GetHostInfoAction
implements PrivilegedAction<String[]> {
    GetHostInfoAction() {
    }

    @Override
    public String[] run() {
        String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
        String providedHostName = System.getProperty("jboss.host.name");
        String providedNodeName = System.getProperty("jboss.node.name");
        if (qualifiedHostName == null) {
            qualifiedHostName = providedHostName;
            if (qualifiedHostName == null) {
                qualifiedHostName = System.getenv("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = System.getenv("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = HostName.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:").matcher(qualifiedHostName).find()) {
                qualifiedHostName = null;
            }
            qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
        }
        if (providedHostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            String string = providedHostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
        if (providedNodeName == null) {
            providedNodeName = providedHostName;
        }
        return new String[]{providedHostName, qualifiedHostName, providedNodeName};
    }
}

