/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.math;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;

public final class HashMath {
    private static final int PRESELECTED_PRIME = 1299827;

    private HashMath() {
    }

    public static int roundToPowerOfTwo(int value) {
        Assert.checkMinimumParameter("value", 0, value);
        Assert.checkMaximumParameter("value", 0x40000000, value);
        return value <= 1 ? value : Integer.highestOneBit(value - 1) << 1;
    }

    public static int multiHashOrdered(int accumulatedHash, int prime, int nextHash) {
        return HashMath.multiplyWrap(accumulatedHash, prime) + nextHash;
    }

    public static int multiHashUnordered(int accumulatedHash, int prime, int nextHash) {
        return HashMath.multiplyWrap(nextHash, prime) + accumulatedHash;
    }

    public static int multiHashOrdered(int accumulatedHash, int nextHash) {
        return HashMath.multiHashOrdered(accumulatedHash, 1299827, nextHash);
    }

    public static int multiHashUnordered(int accumulatedHash, int nextHash) {
        return HashMath.multiHashUnordered(accumulatedHash, 1299827, nextHash);
    }

    public static int multiplyWrap(int a, int b) {
        long r1 = (long)a * (long)b;
        return (int)r1 ^ (int)(r1 >>> 32);
    }
}

