/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.iteration;

import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.ByteIterator;
import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.CodePointIterator;
import java.util.NoSuchElementException;

class Utf8DecodingIterator
extends CodePointIterator {
    private final ByteIterator iter;
    private long offset = 0L;

    Utf8DecodingIterator(ByteIterator iter) {
        this.iter = iter;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    private void seekToNext() {
        while (this.iter.hasNext()) {
            int b = this.iter.next();
            if ((b & 0xC0) == 128) continue;
            this.iter.previous();
            return;
        }
    }

    private void seekToPrev() {
        while (this.iter.hasPrevious()) {
            int b = this.iter.previous();
            if ((b & 0xC0) == 128) continue;
            return;
        }
    }

    @Override
    public int next() {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        int a = this.iter.next();
        if ((a & 0x80) == 0) {
            return a;
        }
        if ((a & 0xC0) == 128) {
            this.seekToNext();
            return 65533;
        }
        if (!this.iter.hasNext()) {
            return 65533;
        }
        int b = this.iter.next();
        if ((b & 0xC0) != 128) {
            this.seekToNext();
            return 65533;
        }
        if ((a & 0xE0) == 192) {
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (!this.iter.hasNext()) {
            return 65533;
        }
        int c = this.iter.next();
        if ((c & 0xC0) != 128) {
            this.seekToNext();
            return 65533;
        }
        if ((a & 0xF0) == 224) {
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        if (!this.iter.hasNext()) {
            return 65533;
        }
        int d = this.iter.next();
        if ((d & 0xC0) != 128) {
            this.seekToNext();
            return 65533;
        }
        if ((a & 0xF8) == 240) {
            return (a & 7) << 18 | (b & 0x3F) << 12 | (c & 0x3F) << 6 | d & 0x3F;
        }
        this.seekToNext();
        return 65533;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException();
        }
        int a = this.iter.peekNext();
        if ((a & 0x80) == 0) {
            return a;
        }
        if ((a & 0xC0) == 128) {
            return 65533;
        }
        this.iter.next();
        if (!this.iter.hasNext()) {
            this.iter.previous();
            return 65533;
        }
        int b = this.iter.peekNext();
        if ((b & 0xC0) != 128) {
            this.iter.previous();
            return 65533;
        }
        if ((a & 0xE0) == 192) {
            this.iter.previous();
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        this.iter.next();
        if (!this.iter.hasNext()) {
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        int c = this.iter.peekNext();
        if ((c & 0xC0) != 128) {
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        if ((a & 0xF0) == 224) {
            this.iter.previous();
            this.iter.previous();
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        this.iter.next();
        if (!this.iter.hasNext()) {
            this.iter.previous();
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        int d = this.iter.peekNext();
        if ((d & 0xC0) != 128) {
            this.iter.previous();
            this.iter.previous();
            this.iter.previous();
            return 65533;
        }
        if ((a & 0xF8) == 240) {
            this.iter.previous();
            this.iter.previous();
            this.iter.previous();
            return (a & 7) << 18 | (b & 0x3F) << 12 | (c & 0x3F) << 6 | d & 0x3F;
        }
        this.iter.previous();
        this.iter.previous();
        this.iter.previous();
        return 65533;
    }

    @Override
    public int previous() {
        if (!this.iter.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.offset;
        int a = this.iter.previous();
        if ((a & 0x80) == 0) {
            return a;
        }
        if ((a & 0xC0) != 128) {
            this.seekToPrev();
            return 65533;
        }
        int cp = a & 0x3F;
        a = this.iter.previous();
        if ((a & 0xE0) == 192) {
            return (a & 0x1F) << 6 | cp;
        }
        if ((a & 0xC0) != 128) {
            this.seekToPrev();
            return 65533;
        }
        cp |= (a & 0x3F) << 6;
        a = this.iter.previous();
        if ((a & 0xF0) == 224) {
            return (a & 0xF) << 12 | cp;
        }
        if ((a & 0xC0) != 128) {
            this.seekToPrev();
            return 65533;
        }
        cp |= (a & 0x3F) << 12;
        a = this.iter.previous();
        if ((a & 0xF8) == 240) {
            return (a & 7) << 18 | cp;
        }
        this.seekToPrev();
        return 65533;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.iter.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int a = this.iter.peekPrevious();
        if ((a & 0x80) == 0) {
            return a;
        }
        if ((a & 0xC0) != 128) {
            return 65533;
        }
        int cp = a & 0x3F;
        this.iter.previous();
        a = this.iter.peekPrevious();
        if ((a & 0xE0) == 192) {
            this.iter.next();
            return (a & 0x1F) << 6 | cp;
        }
        if ((a & 0xC0) != 128) {
            this.iter.next();
            return 65533;
        }
        cp |= (a & 0x3F) << 6;
        this.iter.previous();
        a = this.iter.peekPrevious();
        if ((a & 0xF0) == 224) {
            this.iter.next();
            this.iter.next();
            return (a & 0xF) << 12 | cp;
        }
        if ((a & 0xC0) != 128) {
            this.iter.next();
            this.iter.next();
            return 65533;
        }
        cp |= (a & 0x3F) << 12;
        this.iter.previous();
        a = this.iter.peekPrevious();
        if ((a & 0xF8) == 240) {
            this.iter.next();
            this.iter.next();
            this.iter.next();
            return (a & 7) << 18 | cp;
        }
        this.iter.next();
        this.iter.next();
        this.iter.next();
        return 65533;
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

