/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.iteration;

import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.ByteIterator;
import java.util.NoSuchElementException;

final class DelimitedByteIterator
extends ByteIterator {
    private final ByteIterator iter;
    private final int[] delims;
    long offset;

    DelimitedByteIterator(ByteIterator iter, int ... delims) {
        this.iter = iter;
        this.delims = delims;
        this.offset = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext() && !this.isDelim(this.iter.peekNext());
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        return this.iter.next();
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iter.peekNext();
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.offset;
        return this.iter.previous();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.iter.peekPrevious();
    }

    @Override
    public long getIndex() {
        return this.offset;
    }

    private boolean isDelim(int b) {
        for (int delim : this.delims) {
            if (delim != b) continue;
            return true;
        }
        return false;
    }
}

