/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.iteration;

import com.redhat.insights.agent.shaded.org.wildfly.common.bytes.ByteStringBuilder;
import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.ByteIterator;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.crypto.Mac;

final class ByteArrayIterator
extends ByteIterator {
    private final int len;
    private final byte[] bytes;
    private final int offs;
    private int idx;

    ByteArrayIterator(int len, byte[] bytes, int offs) {
        this.len = len;
        this.bytes = bytes;
        this.offs = offs;
        this.idx = 0;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.len;
    }

    @Override
    public boolean hasPrevious() {
        return this.idx > 0;
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.idx++] & 0xFF;
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + --this.idx] & 0xFF;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.idx] & 0xFF;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.idx - 1] & 0xFF;
    }

    @Override
    public long getIndex() {
        return this.idx;
    }

    @Override
    public void update(MessageDigest digest) throws IllegalStateException {
        digest.update(this.bytes, this.offs + this.idx, this.len - this.idx);
        this.idx = this.len;
    }

    @Override
    public ByteIterator doFinal(MessageDigest digest) throws IllegalStateException {
        this.update(digest);
        return ByteIterator.ofBytes(digest.digest());
    }

    @Override
    public void update(Mac mac) throws IllegalStateException {
        mac.update(this.bytes, this.offs + this.idx, this.len - this.idx);
        this.idx = this.len;
    }

    @Override
    public ByteIterator doFinal(Mac mac) throws IllegalStateException {
        this.update(mac);
        return ByteIterator.ofBytes(mac.doFinal());
    }

    @Override
    public void update(Signature signature) throws SignatureException {
        signature.update(this.bytes, this.offs + this.idx, this.len - this.idx);
        this.idx = this.len;
    }

    @Override
    public boolean verify(Signature signature) throws SignatureException {
        try {
            boolean bl = signature.verify(this.bytes, this.offs + this.idx, this.len - this.idx);
            return bl;
        }
        finally {
            this.idx = this.len;
        }
    }

    @Override
    public ByteArrayOutputStream drainTo(ByteArrayOutputStream stream) {
        stream.write(this.bytes, this.offs + this.idx, this.len - this.idx);
        this.idx = this.len;
        return stream;
    }

    @Override
    public byte[] drain() {
        try {
            byte[] byArray = Arrays.copyOfRange(this.bytes, this.offs + this.idx, this.offs + this.len);
            return byArray;
        }
        finally {
            this.idx = this.len;
        }
    }

    @Override
    public int drain(byte[] dst, int offs, int dlen) {
        int cnt = Math.min(this.len - this.idx, dlen);
        System.arraycopy(this.bytes, offs + this.idx, dst, offs, cnt);
        this.idx += cnt;
        return cnt;
    }

    @Override
    public String drainToUtf8(int count) {
        int cnt = Math.min(this.len - this.idx, count);
        String s = new String(this.bytes, this.idx, cnt, StandardCharsets.UTF_8);
        this.idx += cnt;
        return s;
    }

    @Override
    public String drainToLatin1(int count) {
        int cnt = Math.min(this.len - this.idx, count);
        String s = new String(this.bytes, this.idx, cnt, StandardCharsets.ISO_8859_1);
        this.idx += cnt;
        return s;
    }

    @Override
    public ByteStringBuilder appendTo(ByteStringBuilder builder) {
        builder.append(this.bytes, this.offs + this.idx, this.len - this.idx);
        this.idx = this.len;
        return builder;
    }
}

