/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.iteration;

import com.redhat.insights.agent.shaded.org.wildfly.common._private.CommonMessages;
import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.ByteIterator;
import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.CodePointIterator;
import java.util.NoSuchElementException;

final class Base16DecodingByteIterator
extends ByteIterator {
    private final CodePointIterator iter;
    private int b;
    private long offset;
    private boolean havePair;

    Base16DecodingByteIterator(CodePointIterator iter) {
        this.iter = iter;
    }

    private int calc(int b0, int b1) {
        int d0 = Character.digit(b0, 16);
        int d1 = Character.digit(b1, 16);
        if (d0 == -1 || d1 == -1) {
            throw CommonMessages.msg.invalidHexCharacter();
        }
        return (d0 << 4 | d1) & 0xFF;
    }

    @Override
    public boolean hasNext() {
        if (this.havePair) {
            return true;
        }
        if (!this.iter.hasNext()) {
            return false;
        }
        int b0 = this.iter.next();
        if (!this.iter.hasNext()) {
            throw CommonMessages.msg.expectedEvenNumberOfHexCharacters();
        }
        int b1 = this.iter.next();
        this.b = this.calc(b0, b1);
        this.havePair = true;
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    @Override
    public int next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        this.havePair = false;
        return this.b;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.b;
    }

    @Override
    public int previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int b1 = this.iter.previous();
        int b0 = this.iter.previous();
        this.b = this.calc(b0, b1);
        --this.offset;
        this.havePair = true;
        return this.b;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int b1 = this.iter.previous();
        int b0 = this.iter.peekPrevious();
        this.iter.next();
        return this.calc(b0, b1);
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

