/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.expression;

import com.redhat.insights.agent.shaded.org.wildfly.common.expression.ExpressionNode;
import com.redhat.insights.agent.shaded.org.wildfly.common.expression.LiteralNode;
import com.redhat.insights.agent.shaded.org.wildfly.common.expression.Node;
import com.redhat.insights.agent.shaded.org.wildfly.common.function.ExceptionBiConsumer;

public final class ResolveContext<E extends Exception> {
    private final ExceptionBiConsumer<ResolveContext<E>, StringBuilder, E> function;
    private StringBuilder builder;
    private ExpressionNode current;

    ResolveContext(ExceptionBiConsumer<ResolveContext<E>, StringBuilder, E> function, StringBuilder builder) {
        this.function = function;
        this.builder = builder;
    }

    public String getKey() throws E {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Node key = this.current.getKey();
        if (key instanceof LiteralNode) {
            return key.toString();
        }
        if (key == Node.NULL) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        this.emitToBuilder(b, key);
        return b.toString();
    }

    public void expandDefault(StringBuilder target) throws E {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.emitToBuilder(target, this.current.getDefaultValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitToBuilder(StringBuilder target, Node node) throws E {
        if (node == Node.NULL) {
            return;
        }
        if (node instanceof LiteralNode) {
            target.append(node.toString());
            return;
        }
        StringBuilder old = this.builder;
        try {
            this.builder = target;
            node.emit(this, this.function);
        }
        finally {
            this.builder = old;
        }
    }

    public void expandDefault() throws E {
        this.expandDefault(this.builder);
    }

    public String getExpandedDefault() throws E {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Node defaultValue = this.current.getDefaultValue();
        if (defaultValue instanceof LiteralNode) {
            return defaultValue.toString();
        }
        if (defaultValue == Node.NULL) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        this.emitToBuilder(b, defaultValue);
        return b.toString();
    }

    public boolean hasDefault() {
        return this.current.getDefaultValue() != Node.NULL;
    }

    StringBuilder getStringBuilder() {
        return this.builder;
    }

    ExpressionNode setCurrent(ExpressionNode current) {
        try {
            ExpressionNode expressionNode = this.current;
            return expressionNode;
        }
        finally {
            this.current = current;
        }
    }
}

