/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.expression;

import com.redhat.insights.agent.shaded.org.wildfly.common.expression.Node;
import com.redhat.insights.agent.shaded.org.wildfly.common.expression.ResolveContext;
import com.redhat.insights.agent.shaded.org.wildfly.common.function.ExceptionBiConsumer;
import java.util.HashSet;
import java.util.List;

final class CompositeNode
extends Node {
    private final Node[] subNodes;

    CompositeNode(Node[] subNodes) {
        this.subNodes = subNodes;
    }

    CompositeNode(List<Node> subNodes) {
        this.subNodes = subNodes.toArray(NO_NODES);
    }

    @Override
    <E extends Exception> void emit(ResolveContext<E> context, ExceptionBiConsumer<ResolveContext<E>, StringBuilder, E> resolveFunction) throws E {
        for (Node subNode : this.subNodes) {
            subNode.emit(context, resolveFunction);
        }
    }

    @Override
    void catalog(HashSet<String> strings) {
        for (Node node : this.subNodes) {
            node.catalog(strings);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('*');
        for (Node subNode : this.subNodes) {
            b.append('<').append(subNode.toString()).append('>');
        }
        return b.toString();
    }
}

