/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.array;

import com.redhat.insights.agent.shaded.org.wildfly.common.Assert;
import com.redhat.insights.agent.shaded.org.wildfly.common.iteration.EnumerationIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class ArrayIterator<E>
implements ListIterator<E>,
EnumerationIterator<E> {
    private final E[] elements;
    private final boolean descending;
    private int idx;

    public ArrayIterator(E[] elements) {
        this(elements, false);
    }

    public ArrayIterator(E[] elements, boolean descending) {
        this(elements, descending, descending ? elements.length : 0);
    }

    public ArrayIterator(E[] elements, int startIdx) {
        this(elements, false, startIdx);
    }

    public ArrayIterator(E[] elements, boolean descending, int startIdx) {
        Assert.checkNotNullParam("elements", elements);
        Assert.checkMinimumParameter("startIdx", 0, startIdx);
        Assert.checkMaximumParameter("startIdx", elements.length, startIdx);
        this.elements = elements;
        this.descending = descending;
        this.idx = startIdx;
    }

    @Override
    public boolean hasPrevious() {
        return this.descending ? this.idx < this.elements.length : this.idx > 0;
    }

    @Override
    public boolean hasNext() {
        return this.descending ? this.idx > 0 : this.idx < this.elements.length;
    }

    @Override
    public E previous() {
        int n;
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (this.descending) {
            int n2 = this.idx;
            n = n2;
            this.idx = n2 + 1;
        } else {
            n = this.idx = this.idx - 1;
        }
        return this.elements[n];
    }

    @Override
    public E next() {
        int n;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.descending) {
            n = this.idx = this.idx - 1;
        } else {
            int n2 = this.idx;
            n = n2;
            this.idx = n2 + 1;
        }
        return this.elements[n];
    }

    @Override
    public int nextIndex() {
        return this.descending ? this.idx - 1 : this.idx;
    }

    @Override
    public int previousIndex() {
        return this.descending ? this.idx : this.idx - 1;
    }

    @Override
    public void remove() {
        throw Assert.unsupported();
    }

    @Override
    public void set(E e) {
        throw Assert.unsupported();
    }

    @Override
    public void add(E e) {
        throw Assert.unsupported();
    }
}

