/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.wildfly.common.archive;

import com.redhat.insights.agent.shaded.org.wildfly.common.archive.Index;
import java.util.Arrays;

final class TinyIndex
extends Index {
    private final short[] table;

    TinyIndex(int entries) {
        super(entries);
        short[] array = new short[this.size()];
        Arrays.fill(array, (short)-1);
        this.table = array;
    }

    @Override
    long get(int index) {
        short val = this.table[index];
        return val == -1 ? -1L : (long)(val & 0xFFFF);
    }

    @Override
    void put(int index, long offset) {
        short[] table = this.table;
        short val = table[index];
        while ((long)val != -1L) {
            index = index + 1 & this.getMask();
            val = table[index];
        }
        table[index] = (short)offset;
    }
}

