/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.org.jboss.logging;

import com.redhat.insights.agent.shaded.org.jboss.logging.Logger;
import com.redhat.insights.agent.shaded.org.jboss.logmanager.ExtLogRecord;
import java.util.logging.Level;

final class JBossLogManagerLogger
extends Logger {
    private static final long serialVersionUID = 7429618317727584742L;
    private final com.redhat.insights.agent.shaded.org.jboss.logmanager.Logger logger;

    JBossLogManagerLogger(String name, com.redhat.insights.agent.shaded.org.jboss.logmanager.Logger logger2) {
        super(name);
        this.logger = logger2;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.logger.isLoggable(JBossLogManagerLogger.translate(level));
    }

    @Override
    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        Level translatedLevel = JBossLogManagerLogger.translate(level);
        if (this.logger.isLoggable(translatedLevel)) {
            if (parameters == null) {
                this.logger.log(loggerClassName, translatedLevel, String.valueOf(message), thrown);
            } else {
                this.logger.log(loggerClassName, translatedLevel, String.valueOf(message), ExtLogRecord.FormatStyle.MESSAGE_FORMAT, parameters, thrown);
            }
        }
    }

    @Override
    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        if (parameters == null) {
            this.logger.log(loggerClassName, JBossLogManagerLogger.translate(level), format, thrown);
        } else {
            this.logger.log(loggerClassName, JBossLogManagerLogger.translate(level), format, ExtLogRecord.FormatStyle.PRINTF, parameters, thrown);
        }
    }

    private static Level translate(Logger.Level level) {
        if (level == Logger.Level.TRACE) {
            return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.TRACE;
        }
        if (level == Logger.Level.DEBUG) {
            return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.DEBUG;
        }
        return JBossLogManagerLogger.infoOrHigher(level);
    }

    private static Level infoOrHigher(Logger.Level level) {
        if (level == Logger.Level.INFO) {
            return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.INFO;
        }
        if (level == Logger.Level.WARN) {
            return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.WARN;
        }
        if (level == Logger.Level.ERROR) {
            return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.ERROR;
        }
        if (level == Logger.Level.FATAL) {
            return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.FATAL;
        }
        return com.redhat.insights.agent.shaded.org.jboss.logmanager.Level.ALL;
    }
}

