/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.logging;

import com.redhat.insights.agent.shaded.ShadeLogger;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JulLogger
implements InsightsLogger {
    private final String name;
    private final ShadeLogger delegate;

    public JulLogger(String name) {
        this.name = name;
        this.delegate = ShadeLogger.getLogger(this.name);
    }

    @Override
    public void debug(String message) {
        LogRecord logRecord = new LogRecord(Level.FINER, message);
        logRecord.setLoggerName(this.name);
        this.delegate.log(logRecord);
    }

    @Override
    public void debug(String message, Throwable err) {
        LogRecord logRecord = new LogRecord(Level.FINER, message);
        logRecord.setLoggerName(this.name);
        logRecord.setThrown(err);
        this.delegate.log(logRecord);
    }

    @Override
    public void info(String message) {
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(this.name);
        this.delegate.log(logRecord);
    }

    @Override
    public void error(String message) {
        LogRecord logRecord = new LogRecord(Level.SEVERE, message);
        logRecord.setLoggerName(this.name);
        this.delegate.log(logRecord);
    }

    @Override
    public void error(String message, Throwable err) {
        LogRecord logRecord = new LogRecord(Level.SEVERE, message);
        logRecord.setLoggerName(this.name);
        logRecord.setThrown(err);
        this.delegate.log(logRecord);
    }

    @Override
    public void warning(String message) {
        LogRecord logRecord = new LogRecord(Level.WARNING, message);
        logRecord.setLoggerName(this.name);
        this.delegate.log(logRecord);
    }

    @Override
    public void warning(String message, Throwable err) {
        LogRecord logRecord = new LogRecord(Level.WARNING, message);
        logRecord.setLoggerName(this.name);
        logRecord.setThrown(err);
        this.delegate.log(logRecord);
    }
}

