/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.http;

import com.redhat.insights.agent.shaded.InsightsErrorCode;
import com.redhat.insights.agent.shaded.InsightsException;
import com.redhat.insights.agent.shaded.http.InsightsHttpClient;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.reports.InsightsReport;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class InsightsMultiClient
implements InsightsHttpClient {
    private final InsightsLogger logger;
    private final List<InsightsHttpClient> clients;

    public InsightsMultiClient(InsightsLogger logger2, List<InsightsHttpClient> clients) {
        this.logger = logger2;
        this.clients = clients;
    }

    public InsightsMultiClient(InsightsLogger logger2, InsightsHttpClient ... clients) {
        this.logger = logger2;
        this.clients = Arrays.asList(clients);
    }

    @Override
    public void decorate(InsightsReport report) {
        this.logger.warning("Multiclients do not support direct decoration of reports");
    }

    @Override
    public void sendInsightsReport(String filename, InsightsReport report) {
        String previousExceptionMsg = "";
        for (InsightsHttpClient client : this.clients) {
            try {
                if (!"".equals(previousExceptionMsg)) {
                    report.decorate("app.client.exception", previousExceptionMsg);
                }
                client.sendInsightsReport(filename, report);
                return;
            }
            catch (InsightsException x) {
                this.logger.debug("Client failed, trying next", x);
                previousExceptionMsg = x.getMessage();
            }
        }
        throw new InsightsException(InsightsErrorCode.ERROR_CLIENT_FAILED, "All clients failed: " + this.clients);
    }

    @Override
    public boolean isReadyToSend() {
        boolean isReady = false;
        for (InsightsHttpClient client : this.clients) {
            isReady = isReady || client.isReadyToSend();
        }
        return isReady;
    }
}

