/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.http;

import com.redhat.insights.agent.shaded.InsightsErrorCode;
import com.redhat.insights.agent.shaded.InsightsException;
import com.redhat.insights.agent.shaded.reports.InsightsReport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface InsightsHttpClient {
    public static final String GENERAL_MIME_TYPE = "application/vnd.redhat.runtimes-java-general.analytics+tgz";

    public void decorate(InsightsReport var1);

    public void sendInsightsReport(String var1, InsightsReport var2);

    default public boolean isReadyToSend() {
        return true;
    }

    public static byte[] gzipReport(String report) {
        return InsightsHttpClient.gzipReport(report.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] gzipReport(byte[] report) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(report.length);
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(report);
            gzip.close();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iox) {
                throw new InsightsException(InsightsErrorCode.ERROR_GZIP_FILE, "Failed to GZIP report: " + Arrays.toString(report), iox);
            }
        }
        baos.close();
        return byArray;
    }
}

