/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded.config;

import java.time.Duration;
import java.util.Optional;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface InsightsConfiguration {
    public static final String DEFAULT_RHEL_CERT_FILE_PATH = "/etc/pki/consumer/cert.pem";
    public static final String DEFAULT_RHEL_KEY_FILE_PATH = "/etc/pki/consumer/key.pem";
    public static final String DEFAULT_RHEL_MACHINE_ID_FILE_PATH = "/etc/insights-client/machine-id";
    public static final String DEFAULT_UPLOAD_BASE_URL = "https://cert.console.redhat.com";
    public static final String DEFAULT_UPLOAD_URI = "/api/ingress/v1/upload";
    public static final String DEFAULT_ARCHIVE_UPLOAD_DIR = "/var/tmp/insights-runtimes/uploads";
    public static final String DEFAULT_CERT_HELPER_BINARY = "/opt/jboss-cert-helper";
    public static final long DEFAULT_HTTP_CLIENT_RETRY_INITIAL_DELAY = 2000L;
    public static final double DEFAULT_HTTP_CLIENT_RETRY_BACKOFF_FACTOR = 2.0;
    public static final int DEFAULT_HTTP_CLIENT_RETRY_MAX_ATTEMPTS = 5;

    public String getIdentificationName();

    default public String getCertFilePath() {
        return DEFAULT_RHEL_CERT_FILE_PATH;
    }

    default public String getKeyFilePath() {
        return DEFAULT_RHEL_KEY_FILE_PATH;
    }

    default public String getMachineIdFilePath() {
        return DEFAULT_RHEL_MACHINE_ID_FILE_PATH;
    }

    default public Optional<String> getMaybeAuthToken() {
        return Optional.empty();
    }

    default public String getUploadBaseURL() {
        return DEFAULT_UPLOAD_BASE_URL;
    }

    default public boolean useMTLS() {
        return !this.getMaybeAuthToken().isPresent();
    }

    default public String getUploadUri() {
        return DEFAULT_UPLOAD_URI;
    }

    default public String getArchiveUploadDir() {
        return DEFAULT_ARCHIVE_UPLOAD_DIR;
    }

    default public Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.empty();
    }

    default public boolean isOptingOut() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            return osName.trim().toLowerCase().contains("windows");
        }
        return false;
    }

    default public Duration getConnectPeriod() {
        return Duration.ofDays(1L);
    }

    default public Duration getUpdatePeriod() {
        return Duration.ofMinutes(5L);
    }

    default public long getHttpClientRetryInitialDelay() {
        return 2000L;
    }

    default public double getHttpClientRetryBackoffFactor() {
        return 2.0;
    }

    default public int getHttpClientRetryMaxAttempts() {
        return 5;
    }

    default public String getCertHelperBinary() {
        return DEFAULT_CERT_HELPER_BINARY;
    }

    default public Duration getHttpClientTimeout() {
        return Duration.ofMinutes(1L);
    }

    public static final class ProxyConfiguration {
        private final String host;
        private final int port;

        public ProxyConfiguration(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

