/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent.shaded;

import com.redhat.insights.agent.shaded.Filtering;
import com.redhat.insights.agent.shaded.InsightsCustomScheduledExecutor;
import com.redhat.insights.agent.shaded.InsightsErrorCode;
import com.redhat.insights.agent.shaded.InsightsException;
import com.redhat.insights.agent.shaded.InsightsScheduler;
import com.redhat.insights.agent.shaded.config.InsightsConfiguration;
import com.redhat.insights.agent.shaded.http.InsightsHttpClient;
import com.redhat.insights.agent.shaded.jars.JarInfo;
import com.redhat.insights.agent.shaded.jars.JarUtils;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.reports.InsightsReport;
import com.redhat.insights.agent.shaded.reports.UpdateReportImpl;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class InsightsReportController {
    private final InsightsLogger logger;
    private final InsightsConfiguration configuration;
    private final InsightsReport report;
    private final Supplier<InsightsHttpClient> httpClientSupplier;
    private final InsightsScheduler scheduler;
    private final Filtering masking;
    private final CompletableFuture<String> idHashHolder;
    private final BlockingQueue<JarInfo> jarsToSend;

    private InsightsReportController(InsightsLogger logger2, InsightsConfiguration configuration, InsightsReport report, Supplier<InsightsHttpClient> httpClientSupplier, InsightsScheduler scheduler, BlockingQueue<JarInfo> jarsToSend) {
        this.logger = logger2;
        this.configuration = configuration;
        this.report = report;
        this.httpClientSupplier = httpClientSupplier;
        this.scheduler = scheduler;
        this.jarsToSend = jarsToSend;
        this.masking = Filtering.DEFAULT;
        this.idHashHolder = new CompletableFuture();
    }

    public static InsightsReportController of(InsightsLogger logger2, InsightsConfiguration configuration, InsightsReport report, Supplier<InsightsHttpClient> httpClientSupplier) {
        return new InsightsReportController(logger2, configuration, report, httpClientSupplier, InsightsCustomScheduledExecutor.of(logger2, configuration), new LinkedBlockingQueue<JarInfo>());
    }

    public static InsightsReportController of(InsightsLogger logger2, InsightsConfiguration configuration, InsightsReport report, Supplier<InsightsHttpClient> httpClientSupplier, BlockingQueue<JarInfo> jarsToSend) {
        return new InsightsReportController(logger2, configuration, report, httpClientSupplier, InsightsCustomScheduledExecutor.of(logger2, configuration), jarsToSend);
    }

    public static InsightsReportController of(InsightsLogger logger2, InsightsConfiguration configuration, InsightsReport report, Supplier<InsightsHttpClient> httpClientSupplier, InsightsScheduler scheduler, BlockingQueue<JarInfo> jarsToSend) {
        return new InsightsReportController(logger2, configuration, report, httpClientSupplier, scheduler, jarsToSend);
    }

    public void generate() {
        try {
            if (this.configuration.isOptingOut()) {
                throw new InsightsException(InsightsErrorCode.OPT_OUT, "Opting out of the Red Hat Insights client");
            }
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                throw new InsightsException(InsightsErrorCode.OPT_OUT, "Red Hat Insights is not supported on Windows.");
            }
            Runnable sendConnect = () -> {
                InsightsHttpClient httpClient = this.httpClientSupplier.get();
                if (httpClient.isReadyToSend()) {
                    this.generateConnectReport();
                    try {
                        httpClient.sendInsightsReport(this.getIdHash() + "_connect", this.report);
                    }
                    finally {
                        try {
                            this.report.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.logger.debug("Insights is not configured to send: " + this.configuration);
            };
            this.scheduler.scheduleConnect(sendConnect);
            UpdateReportImpl updateReport = new UpdateReportImpl(this.jarsToSend, this.logger);
            Runnable sendNewJarsIfAny = () -> {
                InsightsHttpClient httpClient = this.httpClientSupplier.get();
                if (httpClient.isReadyToSend() && !this.jarsToSend.isEmpty()) {
                    updateReport.setIdHash(this.getIdHash());
                    updateReport.generateReport(this.masking);
                    httpClient.sendInsightsReport(this.getIdHash() + "_update", updateReport);
                }
            };
            this.scheduler.scheduleJarUpdate(sendNewJarsIfAny);
        }
        catch (InsightsException isx) {
            this.logger.error("Red Hat Insights client scheduler shutdown due to a controller startup error", isx);
            this.scheduler.shutdown();
            throw isx;
        }
    }

    void generateConnectReport() {
        this.report.generateReport(this.masking);
        this.generateAndSetReportIdHash();
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    void generateAndSetReportIdHash() {
        try {
            if (!this.idHashHolder.isDone()) {
                String hash = JarUtils.computeSha512(InsightsHttpClient.gzipReport(this.report.serializeRaw()));
                this.idHashHolder.complete(hash);
                this.report.setIdHash(hash);
            }
        }
        catch (IOException | NoSuchAlgorithmException x) {
            throw new InsightsException(InsightsErrorCode.ERROR_GENERATING_HASH, "Exception when generating ID Hash: ", x);
        }
    }

    String getIdHash() {
        try {
            return this.idHashHolder.get();
        }
        catch (InterruptedException | ExecutionException x) {
            throw new InsightsException(InsightsErrorCode.ERROR_GENERATING_HASH, "Exception while trying to compute ID Hash: ", x);
        }
    }

    public BlockingQueue<JarInfo> getJarsToSend() {
        return this.jarsToSend;
    }

    public InsightsScheduler getScheduler() {
        return this.scheduler;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("InsightsReportController{");
        sb.append("logger=").append(this.logger);
        sb.append(", configuration=").append(this.configuration);
        sb.append(", report=").append(this.report);
        sb.append(", httpClientSupplier=").append(this.httpClientSupplier);
        sb.append(", scheduler=").append(this.scheduler);
        sb.append(", masking=").append(this.masking);
        sb.append(", idHashHolder=").append(this.idHashHolder);
        sb.append(", jarsToSend=").append(this.jarsToSend);
        sb.append(", shutdown=").append(this.isShutdown());
        sb.append('}');
        return sb.toString();
    }
}

