/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent;

import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.shaded.InsightsErrorCode;
import com.redhat.insights.agent.shaded.InsightsException;
import com.redhat.insights.agent.shaded.config.InsightsConfiguration;
import com.redhat.insights.agent.shaded.http.InsightsHttpClient;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.org.apache.http.HttpHost;
import com.redhat.insights.agent.shaded.org.apache.http.ParseException;
import com.redhat.insights.agent.shaded.org.apache.http.client.config.RequestConfig;
import com.redhat.insights.agent.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import com.redhat.insights.agent.shaded.org.apache.http.client.methods.HttpPost;
import com.redhat.insights.agent.shaded.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.redhat.insights.agent.shaded.org.apache.http.entity.ContentType;
import com.redhat.insights.agent.shaded.org.apache.http.entity.mime.HttpMultipartMode;
import com.redhat.insights.agent.shaded.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.redhat.insights.agent.shaded.org.apache.http.impl.client.CloseableHttpClient;
import com.redhat.insights.agent.shaded.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.redhat.insights.agent.shaded.org.apache.http.impl.client.HttpClientBuilder;
import com.redhat.insights.agent.shaded.org.apache.http.impl.client.HttpClients;
import com.redhat.insights.agent.shaded.org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import com.redhat.insights.agent.shaded.org.apache.http.util.EntityUtils;
import com.redhat.insights.agent.shaded.reports.InsightsReport;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class InsightsAgentHttpClient
implements InsightsHttpClient {
    private static final InsightsLogger logger = AgentLogger.getLogger();
    private static final ContentType GENERAL_CONTENT_TYPE = ContentType.create("application/vnd.redhat.runtimes-java-general.analytics+tgz");
    private final Supplier<SSLContext> sslContextSupplier;
    private final InsightsConfiguration configuration;
    private final boolean useMTLS;

    public InsightsAgentHttpClient(InsightsConfiguration configuration, Supplier<SSLContext> sslContextSupplier) {
        this.configuration = configuration;
        this.sslContextSupplier = sslContextSupplier;
        this.useMTLS = !configuration.getMaybeAuthToken().isPresent();
    }

    public InsightsAgentHttpClient(InsightsConfiguration configuration) {
        this.configuration = configuration;
        this.sslContextSupplier = () -> {
            throw new InsightsException(InsightsErrorCode.ERROR_SSL_CREATING_CONTEXT, "Could not create SSL context in Token Auth mode");
        };
        this.useMTLS = false;
    }

    @Override
    public void decorate(InsightsReport report) {
        if (this.useMTLS) {
            report.decorate("transport.type.https", "mtls");
            report.decorate("transport.cert.https", this.configuration.getCertFilePath());
        } else {
            String authToken = this.configuration.getMaybeAuthToken().get();
            report.decorate("transport.type.https", "token");
            report.decorate("auth.token", authToken);
        }
    }

    @Override
    public void sendInsightsReport(String filename, InsightsReport report) {
        this.decorate(report);
        byte[] json = report.serializeRaw();
        logger.debug("Red Hat Insights Report:\n" + new String(json, StandardCharsets.UTF_8));
        this.sendCompressedInsightsReport(filename, InsightsHttpClient.gzipReport(json));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendCompressedInsightsReport(String filename, byte[] bytes) {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        int delay = (int)this.configuration.getHttpClientTimeout().toMillis();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(delay).setConnectTimeout(delay).setSocketTimeout(delay).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        if (this.configuration.getProxyConfiguration().isPresent()) {
            InsightsConfiguration.ProxyConfiguration conf = this.configuration.getProxyConfiguration().get();
            clientBuilder.setRoutePlanner(new DefaultProxyRoutePlanner(new HttpHost(conf.getHost(), conf.getPort(), "http")));
        }
        clientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(this.configuration.getHttpClientRetryMaxAttempts(), true));
        if (this.useMTLS) {
            if (this.sslContextSupplier.get() == null) {
                return;
            }
            clientBuilder.setSSLContext(this.sslContextSupplier.get());
        } else {
            clientBuilder.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE);
        }
        try (CloseableHttpClient client = clientBuilder.build();){
            HttpPost post = this.useMTLS ? this.createPost() : this.createAuthTokenPost();
            post.setHeader("Cache-Control", "no-store");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("file", bytes, GENERAL_CONTENT_TYPE, filename);
            builder.addTextBody("type", "application/vnd.redhat.runtimes-java-general.analytics+tgz");
            post.setEntity(builder.build());
            try (CloseableHttpResponse response = client.execute(post);){
                logger.debug("Red Hat Insights HTTP Client: status=" + response.getStatusLine() + ", body=" + EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8));
                switch (response.getStatusLine().getStatusCode()) {
                    case 201: {
                        logger.debug("Red Hat Insights - Advisor content type with no metadata accepted for processing");
                        return;
                    }
                    case 202: {
                        logger.debug("Red Hat Insights - Payload was accepted for processing");
                        return;
                    }
                    case 401: {
                        throw new InsightsException(InsightsErrorCode.ERROR_HTTP_SEND_AUTH_ERROR, response.getStatusLine().getReasonPhrase());
                    }
                    case 413: {
                        throw new InsightsException(InsightsErrorCode.ERROR_HTTP_SEND_PAYLOAD, response.getStatusLine().getReasonPhrase());
                    }
                    case 415: {
                        throw new InsightsException(InsightsErrorCode.ERROR_HTTP_SEND_INVALID_CONTENT_TYPE, response.getStatusLine().getReasonPhrase());
                    }
                    default: {
                        throw new InsightsException(InsightsErrorCode.ERROR_HTTP_SEND_SERVER_ERROR, response.getStatusLine().toString());
                    }
                }
            }
        }
        catch (ParseException | IOException ioex) {
            logger.debug("Error", ioex);
        }
    }

    HttpPost createAuthTokenPost() {
        String token = this.configuration.getMaybeAuthToken().get();
        HttpPost post = new HttpPost(this.assembleURI(this.configuration.getUploadBaseURL(), this.configuration.getUploadUri()));
        post.setHeader("Authorization", "Bearer " + token);
        return post;
    }

    HttpPost createPost() {
        return new HttpPost(this.assembleURI(this.configuration.getUploadBaseURL(), this.configuration.getUploadUri()));
    }

    URI assembleURI(String url, String path) {
        String fullURL = !url.endsWith("/") && !path.startsWith("/") ? url + "/" + path : (url.endsWith("/") && path.startsWith("/") ? url + path.substring(1) : url + path);
        return URI.create(fullURL);
    }

    @Override
    public boolean isReadyToSend() {
        return !this.useMTLS || this.sslContextSupplier.get() != null;
    }

    public String toString() {
        if (this.useMTLS) {
            return "InsightsApacheHttpClient{keyFile= " + this.configuration.getKeyFilePath() + ", certFile= " + this.configuration.getCertFilePath() + ", url= " + this.assembleURI(this.configuration.getUploadBaseURL(), this.configuration.getUploadUri()) + '}';
        }
        return "InsightsApacheHttpClient{token= " + this.configuration.getMaybeAuthToken().get() + ", url= " + this.assembleURI(this.configuration.getUploadBaseURL(), this.configuration.getUploadUri()) + '}';
    }
}

