/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent;

import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.shaded.jars.JarAnalyzer;
import com.redhat.insights.agent.shaded.jars.JarInfo;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

public final class ClassNoticer
implements ClassFileTransformer {
    private static final InsightsLogger logger = AgentLogger.getLogger();
    private final BlockingQueue<JarInfo> jarsToSend;
    private final JarAnalyzer analyzer;
    private final Set<String> seenJarHashes = new HashSet<String>();
    private final Set<String> seenUrls = new HashSet<String>();

    public ClassNoticer(BlockingQueue<JarInfo> jarsToSend) {
        this.jarsToSend = jarsToSend;
        this.analyzer = new JarAnalyzer(logger, true);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> redef, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        if (protectionDomain == null || protectionDomain.getCodeSource() == null) {
            return bytes;
        }
        URL jarUrl = protectionDomain.getCodeSource().getLocation();
        String jarLoc = jarUrl.toString();
        if (jarLoc.endsWith("WEB-INF/classes!/")) {
            return bytes;
        }
        try {
            if (!this.seenUrls.contains(jarLoc)) {
                JarInfo jarInfo;
                String sha512;
                this.seenUrls.add(jarLoc);
                Optional<JarInfo> oJar = this.analyzer.process(jarUrl);
                if (oJar.isPresent() && !this.seenJarHashes.contains(sha512 = (jarInfo = oJar.get()).attributes().get("sha512Checksum"))) {
                    this.seenJarHashes.add(sha512);
                    if (!this.jarsToSend.offer(jarInfo)) {
                        logger.error("Could not enqueue info for jar: " + jarUrl);
                    }
                }
            }
        }
        catch (URISyntaxException e) {
            logger.info("Jar with unrecognized URI seen: " + jarUrl);
        }
        return bytes;
    }
}

