/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent;

import com.redhat.insights.agent.AgentConfiguration;
import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.AgentSubreportSerializer;
import com.redhat.insights.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.redhat.insights.agent.shaded.jars.ClasspathJarInfoSubreport;
import com.redhat.insights.agent.shaded.jars.JarInfo;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.reports.InsightsSubreport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

public class AgentSubreport
implements InsightsSubreport {
    private static final long POLL_PROPERTY_TIMEOUT_MS = 10000L;
    private static final InsightsLogger logger = AgentLogger.getLogger();
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final ClasspathJarInfoSubreport jarsReport;
    private final AgentConfiguration agentConfig;
    private String guessedWorkload = "Unidentified";
    private static final Map<String, Function<Class<?>, String>> activeGuesses = new HashMap();

    private AgentSubreport(ClasspathJarInfoSubreport jarsReport, AgentConfiguration agentConfig) {
        this.jarsReport = jarsReport;
        this.agentConfig = agentConfig;
    }

    public static InsightsSubreport of(ClasspathJarInfoSubreport jarsReport, AgentConfiguration agentConfig) {
        return new AgentSubreport(jarsReport, agentConfig);
    }

    @Override
    public void generateReport() {
        Collection<JarInfo> jarInfos;
        if (this.jarsReport.getJarInfos().isEmpty()) {
            this.jarsReport.generateReport();
        }
        if ((jarInfos = this.jarsReport.getJarInfos()).isEmpty()) {
            logger.warning("No JARs found in AgentSubreport");
        } else {
            this.fingerprintReflectively(jarInfos);
        }
    }

    private void fingerprintReflectively(Collection<JarInfo> jarInfos) {
        String workload = "";
        for (Map.Entry<String, Function<Class<?>, String>> guess : activeGuesses.entrySet()) {
            try {
                Class<?> clazz = Class.forName(guess.getKey());
                workload = guess.getValue().apply(clazz);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (!workload.isEmpty()) {
            this.guessedWorkload = workload;
        }
    }

    static String fingerprintTomcat(Class<?> __) {
        try {
            Class.forName("com.redhat.insights.agent.shaded.org.apache.tomcat.vault.VaultInteraction");
        }
        catch (ClassNotFoundException _x) {
            return "Tomcat";
        }
        return "JWS";
    }

    static String fingerprintQuarkus(Class<?> qClazz) {
        String quarkusVersion = qClazz.getPackage().getImplementationVersion();
        return "Quarkus " + quarkusVersion;
    }

    static Class<?> getModuleClass() throws ClassNotFoundException {
        return AgentSubreport.class.getClassLoader().loadClass("io.cryostat.agent.shaded.org.jboss.modules.Module");
    }

    static ClassLoader getModuleClassLoader(Object moduleLoader, String moduleName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getClassLoaderMethod = AgentSubreport.getModuleClass().getDeclaredMethod("getClassLoader", EMPTY_CLASS_ARRAY);
        return (ClassLoader)getClassLoaderMethod.invoke(AgentSubreport.loadModule(moduleLoader, moduleName), EMPTY_OBJECT_ARRAY);
    }

    static Object loadModule(Object moduleLoader, String moduleName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method loadModuleMethod = moduleLoader.getClass().getMethod("loadModule", String.class);
        return loadModuleMethod.invoke(moduleLoader, moduleName);
    }

    static String fingerprintJBoss(Class<?> moduleClass) {
        try {
            Method getBootModuleLoaderMethod = AgentSubreport.getModuleClass().getDeclaredMethod("getBootModuleLoader", EMPTY_CLASS_ARRAY);
            String modulePath = AgentSubreport.pollProperty("module.path");
            if (modulePath != null) {
                Object moduleLoader = getBootModuleLoaderMethod.invoke(null, EMPTY_OBJECT_ARRAY);
                ClassLoader versionModuleClassLoader = AgentSubreport.getModuleClassLoader(moduleLoader, "io.cryostat.agent.shaded.org.jboss.as.version");
                String home = AgentSubreport.pollProperty("jboss.home.dir");
                Class<?> moduleLoaderClass = AgentSubreport.getJBossModuleLoaderClass(moduleLoader.getClass());
                Class<?> productConfigClass = versionModuleClassLoader.loadClass("io.cryostat.agent.shaded.org.jboss.as.version.ProductConfig");
                Method fromFilesystemSlotMethod = productConfigClass.getDeclaredMethod("fromFilesystemSlot", moduleLoaderClass, String.class, Map.class);
                Object productConfig = fromFilesystemSlotMethod.invoke(null, moduleLoaderClass.cast(moduleLoader), home, AgentSubreport.getPropertiesPrivileged());
                return (String)productConfigClass.getDeclaredMethod("getPrettyVersionString", EMPTY_CLASS_ARRAY).invoke(productConfig, EMPTY_OBJECT_ARRAY);
            }
            logger.debug("Module path did not become available");
        }
        catch (Exception ex) {
            logger.debug("Ignoring exception during JBoss probe", ex);
        }
        return "Unknown EAP / Wildfly - possibly misconfigured";
    }

    private static String pollProperty(String property) {
        long timeout = System.currentTimeMillis() + 10000L;
        String value = AgentSubreport.getPropertyPrivileged(property, null);
        while (value == null && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(200L);
                value = AgentSubreport.getPropertyPrivileged(property, null);
            }
            catch (InterruptedException ex) {
                return value;
            }
        }
        return value;
    }

    private static String getPropertyPrivileged(String property, String defaultValue) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> System.getProperty(property, defaultValue));
        }
        return System.getProperty(property, defaultValue);
    }

    private static Properties getPropertiesPrivileged() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> System.getProperties());
        }
        return System.getProperties();
    }

    static Class<?> getJBossModuleLoaderClass(Class<?> subModuleLoaderClass) {
        if ("io.cryostat.agent.shaded.org.jboss.modules.ModuleLoader".equals(subModuleLoaderClass.getName())) {
            return subModuleLoaderClass;
        }
        if ("java.lang.Object".equals(subModuleLoaderClass.getName())) {
            throw new IllegalArgumentException(subModuleLoaderClass + " is not a subclass of org.jboss.modules.ModuleLoader");
        }
        return AgentSubreport.getJBossModuleLoaderClass(subModuleLoaderClass.getSuperclass());
    }

    @Override
    public String getVersion() {
        return "1.0.1";
    }

    @Override
    public JsonSerializer<InsightsSubreport> getSerializer() {
        return new AgentSubreportSerializer();
    }

    public String getGuessedWorkload() {
        return this.guessedWorkload;
    }

    public String isOCP() {
        return String.valueOf(this.agentConfig.isOCP());
    }

    public String getPodName() {
        return this.agentConfig.getPodName();
    }

    public String getPodNamespace() {
        return this.agentConfig.getPodNamespace();
    }

    static {
        activeGuesses.put("org.springframework.boot.SpringApplication", __ -> "Spring Boot");
        activeGuesses.put("org.springframework.boot.loader.Launcher", __ -> "Spring Boot");
        activeGuesses.put("org.springframework.boot.loader.launch.Launcher", __ -> "Spring Boot");
        activeGuesses.put("io.cryostat.agent.shaded.org.jboss.modules.Module", AgentSubreport::fingerprintJBoss);
        activeGuesses.put("io.quarkus.bootstrap.runner.QuarkusEntryPoint", AgentSubreport::fingerprintQuarkus);
        activeGuesses.put("io.cryostat.agent.shaded.org.apache.shaded.catalina.startup.Bootstrap", AgentSubreport::fingerprintTomcat);
    }
}

