/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent;

import com.redhat.insights.agent.AgentBasicReport;
import com.redhat.insights.agent.AgentConfiguration;
import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.ClassNoticer;
import com.redhat.insights.agent.InsightsAgentHttpClient;
import com.redhat.insights.agent.shaded.InsightsException;
import com.redhat.insights.agent.shaded.InsightsReportController;
import com.redhat.insights.agent.shaded.http.InsightsFileWritingClient;
import com.redhat.insights.agent.shaded.http.InsightsHttpClient;
import com.redhat.insights.agent.shaded.jars.JarInfo;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;

public final class AgentMain {
    private static final AgentLogger logger = AgentLogger.getLogger();
    private final AgentConfiguration configuration;
    private final BlockingQueue<JarInfo> waitingJars;
    private static boolean loaded = false;

    private AgentMain(AgentConfiguration configuration, BlockingQueue<JarInfo> jarsToSend) {
        this.configuration = configuration;
        this.waitingJars = jarsToSend;
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        AgentMain.startAgent(agentArgs, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        AgentMain.startAgent(agentArgs, instrumentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAgent(String agentArgs, Instrumentation instrumentation) {
        Class<AgentMain> clazz = AgentMain.class;
        synchronized (AgentMain.class) {
            if (loaded) {
                logger.warning("Insights agent already loaded, skipping");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            loaded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (agentArgs == null || agentArgs.isEmpty()) {
                logger.error("Unable to start Red Hat Insights agent: Need config arguments");
                return;
            }
            Optional<AgentConfiguration> oArgs = AgentMain.parseArgs(agentArgs);
            if (!oArgs.isPresent()) {
                return;
            }
            AgentConfiguration config = oArgs.get();
            if (!AgentMain.shouldContinue(config)) {
                logger.info("Config indicates Red Hat Insights agent is not to be run. Not starting agent capability.");
                return;
            }
            if (config.isDebug()) {
                logger.setDebugDelegate();
                logger.debug("Running in debug mode");
            }
            LinkedBlockingQueue<JarInfo> jarsToSend = new LinkedBlockingQueue<JarInfo>();
            try {
                logger.info("Starting Red Hat Insights agent");
                new AgentMain(config, jarsToSend).start();
                ClassNoticer noticer = new ClassNoticer(jarsToSend);
                instrumentation.addTransformer(noticer);
            }
            catch (Throwable t) {
                logger.error("Unable to start Red Hat Insights client", t);
            }
            return;
        }
    }

    static boolean shouldContinue(AgentConfiguration config) {
        if (config.isOptingOut()) {
            return false;
        }
        try {
            String obfuscatedStem = "com.redhat";
            String obfuscatedSubPackageAndClass = ".insights.InsightsReportController";
            Class.forName(obfuscatedStem + obfuscatedSubPackageAndClass);
            if (config.isOCP()) {
                if (config.shouldDefer()) {
                    logger.warning("Insights builtin support is available, deferring to that");
                    return false;
                }
            } else {
                logger.warning("Insights builtin support is available, deferring to that");
                return false;
            }
            logger.warning("Starting Red Hat Insights client: Builtin support for OpenShift is available, but the agent is configured to run anyway. Ensure that this configuration is correct.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return true;
    }

    static Optional<AgentConfiguration> parseArgs(String agentArgs) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (String pair : agentArgs.split(";")) {
            String[] kv = pair.split("=");
            if (kv.length != 2) {
                logger.error("Unable to start Red Hat Insights agent: Malformed config arguments (should be key-value pairs)");
                return Optional.empty();
            }
            out.put(kv[0], kv[1]);
        }
        AgentConfiguration config = new AgentConfiguration(out);
        if (config.getIdentificationName() == null || "".equals(config.getIdentificationName())) {
            logger.error("Unable to start Red Hat Insights agent: App requires a name for identification");
            return Optional.empty();
        }
        logger.debug(config.toString());
        return Optional.of(config);
    }

    private void start() {
        AgentBasicReport report = AgentBasicReport.of(this.configuration);
        Supplier<InsightsHttpClient> clientSupplier = this.getInsightsClientSupplier();
        try {
            InsightsReportController controller = InsightsReportController.of(logger, this.configuration, report, clientSupplier, this.waitingJars);
            controller.generate();
        }
        catch (InsightsException e) {
            logger.info("Unable to start Red Hat Insights agent: " + e.getMessage());
        }
    }

    private Supplier<InsightsHttpClient> getInsightsClientSupplier() {
        if (this.configuration.isOCP()) {
            return () -> new InsightsAgentHttpClient(this.configuration);
        }
        return () -> new InsightsFileWritingClient(logger, this.configuration);
    }
}

