/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent;

import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.shaded.config.EnvAndSysPropsInsightsConfiguration;
import com.redhat.insights.agent.shaded.config.InsightsConfiguration;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;

public final class AgentConfiguration
extends EnvAndSysPropsInsightsConfiguration {
    static final String TRUE = "true";
    static final String FALSE = "false";
    static final String AGENT_ARG_NAME = "name";
    static final String AGENT_ARG_TOKEN = "token";
    static final String AGENT_ARG_TOKEN_FILE = "token_file";
    static final String AGENT_ARG_BASE_URL = "base_url";
    static final String AGENT_ARG_UPLOAD_URI = "uri";
    static final String AGENT_ARG_PROXY = "proxy";
    static final String AGENT_ARG_PROXY_PORT = "proxy_port";
    static final String AGENT_ARG_OPT_OUT = "opt_out";
    static final String AGENT_ARG_DEBUG = "debug";
    static final String AGENT_ARG_SHOULD_DEFER = "should_defer";
    static final String AGENT_ARG_POD_NAME = "pod_name";
    static final String AGENT_ARG_POD_NAMESPACE = "pod_namespace";
    static final String PROPERTY_NOT_GIVEN_DEFAULT = "[NONE]";
    private final Map<String, String> args;
    private static final AgentLogger logger = AgentLogger.getLogger();
    private String tokenValue = null;

    public AgentConfiguration(Map<String, String> args) {
        this.args = args;
    }

    @Override
    public synchronized Optional<String> getMaybeAuthToken() {
        if (this.tokenValue != null) {
            return Optional.of(this.tokenValue);
        }
        this.tokenValue = this.args.get(AGENT_ARG_TOKEN);
        if (this.tokenValue != null) {
            return Optional.of(this.tokenValue);
        }
        String path = this.args.get(AGENT_ARG_TOKEN_FILE);
        if (path != null) {
            try {
                byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
                this.tokenValue = new String(encoded, Charset.defaultCharset());
                return Optional.of(this.tokenValue);
            }
            catch (IOException e) {
                logger.warning("Unable to read specified token file: " + path + " this is probably misconfiguration");
            }
        }
        return super.getMaybeAuthToken();
    }

    @Override
    public String getIdentificationName() {
        String out = this.args.get(AGENT_ARG_NAME);
        if (out != null) {
            return out;
        }
        return super.getIdentificationName();
    }

    @Override
    public String getCertFilePath() {
        return "";
    }

    @Override
    public String getKeyFilePath() {
        return "";
    }

    @Override
    public String getUploadBaseURL() {
        if (this.args.containsKey(AGENT_ARG_BASE_URL)) {
            return this.args.get(AGENT_ARG_BASE_URL);
        }
        return super.getUploadBaseURL();
    }

    @Override
    public String getUploadUri() {
        if (this.args.containsKey(AGENT_ARG_UPLOAD_URI)) {
            return this.args.get(AGENT_ARG_UPLOAD_URI);
        }
        return super.getUploadUri();
    }

    @Override
    public Optional<InsightsConfiguration.ProxyConfiguration> getProxyConfiguration() {
        if (this.args.containsKey(AGENT_ARG_PROXY) && this.args.containsKey(AGENT_ARG_PROXY_PORT)) {
            return Optional.of(new InsightsConfiguration.ProxyConfiguration(this.args.get(AGENT_ARG_PROXY), Integer.parseUnsignedInt(this.args.get(AGENT_ARG_PROXY_PORT))));
        }
        return super.getProxyConfiguration();
    }

    @Override
    public boolean isOptingOut() {
        if (this.args.containsKey(AGENT_ARG_OPT_OUT)) {
            return TRUE.equalsIgnoreCase(this.args.get(AGENT_ARG_OPT_OUT));
        }
        return super.isOptingOut();
    }

    public boolean isDebug() {
        return TRUE.equalsIgnoreCase(this.args.getOrDefault(AGENT_ARG_DEBUG, FALSE));
    }

    public boolean shouldDefer() {
        return TRUE.equalsIgnoreCase(this.args.getOrDefault(AGENT_ARG_SHOULD_DEFER, FALSE));
    }

    @Override
    public String toString() {
        return "AgentConfiguration{args=" + this.args + '}';
    }

    public boolean isOCP() {
        return this.getMaybeAuthToken().isPresent();
    }

    public String getPodNamespace() {
        return this.args.getOrDefault(AGENT_ARG_POD_NAMESPACE, PROPERTY_NOT_GIVEN_DEFAULT);
    }

    public String getPodName() {
        return this.args.getOrDefault(AGENT_ARG_POD_NAME, PROPERTY_NOT_GIVEN_DEFAULT);
    }
}

