/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.agent;

import com.redhat.insights.agent.AgentConfiguration;
import com.redhat.insights.agent.AgentLogger;
import com.redhat.insights.agent.AgentSubreport;
import com.redhat.insights.agent.shaded.config.InsightsConfiguration;
import com.redhat.insights.agent.shaded.jars.ClasspathJarInfoSubreport;
import com.redhat.insights.agent.shaded.logging.InsightsLogger;
import com.redhat.insights.agent.shaded.reports.AbstractTopLevelReportBase;
import com.redhat.insights.agent.shaded.reports.InsightsSubreport;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;

public class AgentBasicReport
extends AbstractTopLevelReportBase {
    private static final InsightsLogger logger = AgentLogger.getLogger();

    private AgentBasicReport(InsightsConfiguration config, Map<String, InsightsSubreport> subReports) {
        super(logger, config, subReports);
    }

    public static AgentBasicReport of(AgentConfiguration configuration) {
        HashMap<String, InsightsSubreport> reports = new HashMap<String, InsightsSubreport>();
        ClasspathJarInfoSubreport jarsReport = new ClasspathJarInfoSubreport(logger);
        reports.put("jars", jarsReport);
        reports.put("details", AgentSubreport.of(jarsReport, configuration));
        return new AgentBasicReport(configuration, reports);
    }

    @Override
    protected long getProcessPID() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    @Override
    protected Package[] getPackages() {
        return Package.getPackages();
    }
}

