/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.monitor.brave.internal;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.BraveExecutorService;
import com.github.kristofa.brave.okhttp.BraveTracingInterceptor;
import io.crnk.client.http.okhttp.OkHttpAdapterListener;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpBraveIntegration
implements OkHttpAdapterListener {
    private Brave brave;

    public OkHttpBraveIntegration(Brave brave) {
        this.brave = brave;
    }

    public void onBuild(OkHttpClient.Builder builder) {
        BraveTracingInterceptor interceptor = this.buildInterceptor();
        BraveExecutorService tracePropagatingExecutor = this.buildExecutor();
        builder.addInterceptor((Interceptor)interceptor);
        builder.addNetworkInterceptor((Interceptor)interceptor);
        builder.dispatcher(new Dispatcher((ExecutorService)tracePropagatingExecutor));
    }

    protected BraveExecutorService buildExecutor() {
        return new BraveExecutorService(new Dispatcher().executorService(), this.brave.serverSpanThreadBinder());
    }

    protected BraveTracingInterceptor buildInterceptor() {
        BraveTracingInterceptor.Builder tracingBuilder = BraveTracingInterceptor.builder((Brave)this.brave);
        return tracingBuilder.build();
    }
}

