/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.monitor.brave.internal;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.httpclient.BraveHttpRequestInterceptor;
import com.github.kristofa.brave.httpclient.BraveHttpResponseInterceptor;
import io.crnk.client.http.apache.HttpClientAdapterListener;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpClientBraveIntegration
implements HttpClientAdapterListener {
    private Brave brave;
    private SpanNameProvider spanNameProvider;

    public HttpClientBraveIntegration(Brave brave, SpanNameProvider spanNameProvider) {
        this.brave = brave;
        this.spanNameProvider = spanNameProvider;
    }

    public void onBuild(HttpClientBuilder builder) {
        ClientRequestInterceptor clientRequestInterceptor = this.brave.clientRequestInterceptor();
        ClientResponseInterceptor clientResponseInterceptor = this.brave.clientResponseInterceptor();
        builder.addInterceptorFirst((HttpRequestInterceptor)new BraveHttpRequestInterceptor(clientRequestInterceptor, this.spanNameProvider));
        builder.addInterceptorFirst((HttpResponseInterceptor)new BraveHttpResponseInterceptor(clientResponseInterceptor));
    }
}

