/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.monitor.brave.internal;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.DefaultQuerySpecSerializer;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.monitor.brave.internal.BraveRepositoryFilter;
import java.util.Map;

public class BraveUtil {
    private BraveUtil() {
    }

    public static String getQuery(RepositoryRequestSpec request, ResourceRegistry resourceRegistry) {
        QueryAdapter queryAdapter = request.getQueryAdapter();
        StringBuilder builder = new StringBuilder();
        builder.append("?");
        if (queryAdapter instanceof QuerySpecAdapter) {
            QuerySpec querySpec = request.getQuerySpec(queryAdapter.getResourceInformation());
            DefaultQuerySpecSerializer serializer = new DefaultQuerySpecSerializer(resourceRegistry);
            Map parameters = serializer.serialize(querySpec);
            for (Map.Entry entry : parameters.entrySet()) {
                if (builder.length() > 1) {
                    builder.append("&");
                }
                builder.append((String)entry.getKey());
                builder.append("=");
                builder.append(StringUtils.join((String)",", (Iterable)((Iterable)entry.getValue())));
            }
            return builder.toString();
        }
        return null;
    }

    public static String getComponentName(RepositoryRequestSpec request) {
        ResourceField relationshipField = request.getRelationshipField();
        StringBuilder pathBuilder = new StringBuilder();
        String method = request.getMethod().toString();
        pathBuilder.append("crnk");
        pathBuilder.append(BraveRepositoryFilter.COMPONENT_NAME_SEPARATOR);
        pathBuilder.append(method);
        pathBuilder.append(BraveRepositoryFilter.COMPONENT_NAME_SEPARATOR);
        pathBuilder.append("/");
        if (relationshipField == null) {
            pathBuilder.append(request.getQueryAdapter().getResourceInformation().getResourceType());
        } else {
            pathBuilder.append(relationshipField.getParentResourceInformation().getResourceType());
        }
        Iterable ids = request.getIds();
        if (ids != null) {
            pathBuilder.append("/");
            pathBuilder.append(StringUtils.join((String)",", (Iterable)ids));
        }
        if (relationshipField != null) {
            pathBuilder.append("/");
            pathBuilder.append(relationshipField.getJsonName());
        }
        return pathBuilder.toString();
    }
}

