package io.contract_testing.contractcase.definitions.states;

/**
 * The base class for all ContractCase State Descriptors. You shouldn't need to extend this.
 * <p>
 * You don't need to read the documentation for this class unless you are working
 * on a wrapper for ContractCase.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.471Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.states.AnyState")
public abstract class AnyState extends software.amazon.jsii.JsiiObject {

    protected AnyState(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AnyState(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The base class for all ContractCase State Descriptors. You shouldn't need to extend this.
     * <p>
     * You don't need to read the documentation for this class unless you are working
     * on a wrapper for ContractCase.
     * <p>
     * @param stateType This parameter is required.
     * @param stateName <ul><li>The name of the state used by this example.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AnyState(final @org.jetbrains.annotations.NotNull java.lang.String stateType, final @org.jetbrains.annotations.NotNull java.lang.String stateName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stateType, "stateType is required"), java.util.Objects.requireNonNull(stateName, "stateName is required") });
    }

    /**
     * You shouldn't need to override this method.
     * <p>
     * You don't need to call this
     * method, unless working on a wrapper for ContractCase.
     * <p>
     * This method returns the entire state descriptor as a JSON string, as a convenience
     * so that wrapper libraries don't need to figure out how to walk a tree of example objects.
     * <p>
     * @return A JSON string representation of this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String stringify() {
        return software.amazon.jsii.Kernel.call(this, "stringify", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * You shouldn't need to override or call this method.
     * <p>
     * It exists because the ContractCase matcher format is not legal in all languages that ContractCase supports.
     * <p>
     * It isn't called by any implementation directly, it's used on the javascript side by <code>JSON.stringify()</code>.
     * <p>
     * Calling it from a wrapper library will return unhelpful results, as JSii can't map all objects that it returns.
     * <p>
     * WARNING: Do not return a string from this method. You must instead return
     * an object that can be serialised to JSON following the matcher format
     * described in <a href="https://case.contract-testing.io/docs/reference/plugin-framework">Extending ContractCase</a>.
     * <p>
     * @return An object in the matcher format described <a href="https://case.contract-testing.io/docs/reference/plugin-framework">in the Extending ContractCase documentation</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The name of this state, used to determine which state handler to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStateName() {
        return software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends io.contract_testing.contractcase.definitions.states.AnyState {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
