package io.contract_testing.contractcase.definitions.matchers.strings;

/**
 * Transformation matcher that matches a JSON.stringify()ed version of the given object.
 * <p>
 * For example, if the actual data is the string:
 * <p>
 * <blockquote><pre>
 * "{\"foo\":2}"
 * </pre></blockquote>
 * <p>
 * then you could match it with:
 * <p>
 * <blockquote><pre>
 * StringifiedJson({
 *   "foo": 2
 * })
 * </pre></blockquote>
 * <p>
 * or
 * <p>
 * <blockquote><pre>
 * StringifiedJson({
 *   "foo": AnyNumber(2)
 * })
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.471Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.strings.StringifiedJson")
public class StringifiedJson extends io.contract_testing.contractcase.definitions.matchers.base.AnyMatcher {

    protected StringifiedJson(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringifiedJson(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Transformation matcher that matches a JSON.stringify()ed version of the given object.
     * <p>
     * For example, if the actual data is the string:
     * <p>
     * <blockquote><pre>
     * "{\"foo\":2}"
     * </pre></blockquote>
     * <p>
     * then you could match it with:
     * <p>
     * <blockquote><pre>
     * StringifiedJson({
     *   "foo": 2
     * })
     * </pre></blockquote>
     * <p>
     * or
     * <p>
     * <blockquote><pre>
     * StringifiedJson({
     *   "foo": AnyNumber(2)
     * })
     * </pre></blockquote>
     * <p>
     * @param child <ul><li>The object or matcher that matches the decoded.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StringifiedJson(final @org.jetbrains.annotations.NotNull java.lang.Object child) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { child });
    }

    /**
     * For non-TypeScript implementations (see <code>AnyMatcher.toJSON</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
