package io.contract_testing.contractcase.definitions.matchers.strings;

/**
 * Matches any string that begins with a matchable prefix, and ends with a constant suffix.
 * <p>
 * At match time, the actual string is checked for the expected constant suffix,
 * and then the beginning of the string is passed to the prefix matcher.
 * The prefix matcher must be expecting a string.
 * See also {@link matchers.strings.StringPrefix StringPrefix}
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.470Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.strings.StringSuffix")
public class StringSuffix extends io.contract_testing.contractcase.definitions.matchers.base.AnyMatcher {

    protected StringSuffix(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringSuffix(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param prefix <ul><li>A string or matcher to match against the prefix.</li></ul> This parameter is required.
     * @param suffix <ul><li>The suffix for the matched string.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StringSuffix(final @org.jetbrains.annotations.NotNull java.lang.Object prefix, final @org.jetbrains.annotations.NotNull java.lang.String suffix) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { prefix, java.util.Objects.requireNonNull(suffix, "suffix is required") });
    }

    /**
     * For non-TypeScript implementations (see <code>AnyMatcher.toJSON</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
