package io.contract_testing.contractcase.definitions.matchers.http;

/**
 * Matches an HTTP status code.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.http.HttpStatusCode")
public class HttpStatusCode extends io.contract_testing.contractcase.definitions.matchers.base.AnyMatcherWithExample {

    protected HttpStatusCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpStatusCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Matches an HTTP status code.
     * <p>
     * Matching can be relaxed with `X`, eg `"4XX"` or `"5XX"`. This is useful for error handling.
     * If you need to match multiple specific statues, you can provide an array of string or numbers.
     * This behaviour is provided so that you can offer flexibility to the
     * implementation if the code path for multiple status codes is exactly the
     * same. It is not appropriate to use multiple status codes if the code paths
     * are intended to be different. For more context, see
     * {@link https://case.contract-testing.io/docs/faq#how-do-i-tell-contractcase-that-a-field-is-optional the section on optional values in the documentation}
     * for more details.
     * <p>
     * @param statusCode <ul><li>The http status code to match, expressed as a number or string (eg <code>200</code>, <code>"404"</code> or <code>"4XX"</code>).</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpStatusCode(final @org.jetbrains.annotations.NotNull java.lang.Object statusCode) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (
                 !(statusCode instanceof java.lang.String)
                && !(statusCode instanceof java.util.List)
            ) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("statusCode")
                        .append(" to be one of: java.lang.String, java.util.List<java.lang.String>; received ")
                        .append(statusCode.getClass()).toString());
            }
            if (statusCode instanceof java.util.List) {
                @SuppressWarnings("unchecked")
                final java.util.List<java.lang.String> __cast_b5b07b = (java.util.List<java.lang.String>)statusCode;
                for (int __idx_acf294 = 0; __idx_acf294 < __cast_b5b07b.size(); __idx_acf294++) {
                    final java.lang.String __val_acf294 = __cast_b5b07b.get(__idx_acf294);
                }
            }
        }
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(statusCode, "statusCode is required") });
    }

    /**
     * For non-TypeScript implementations (see <code>AnyMatcher.toJSON</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
