package io.contract_testing.contractcase.definitions.matchers.base;

/**
 * This is a passthrough matcher that does nothing except call the child matcher with the current actual data.
 * <p>
 * It's useful for taking advantage of the context cascading available on all
 * matchers without needing to write you own matcher. Extend it if you want to
 * make a matcher that only changes the context object. If you don't know what
 * this means, you don't need to extend this matcher.
 * <p>
 * Due to limitations with JSii, extending implementations MUST NOT override
 * <code>toJSON</code>, or MUST return the result of <code>super.toJSON()</code> as part of their
 * toJSON method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.459Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.base.CascadingContextMatcher")
public abstract class CascadingContextMatcher extends io.contract_testing.contractcase.definitions.matchers.base.AnyMatcher {

    protected CascadingContextMatcher(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CascadingContextMatcher(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * This is a passthrough matcher that does nothing except call the child matcher with the current actual data.
     * <p>
     * It's useful for taking advantage of the context cascading available on all
     * matchers without needing to write you own matcher. Extend it if you want to
     * make a matcher that only changes the context object. If you don't know what
     * this means, you don't need to extend this matcher.
     * <p>
     * Due to limitations with JSii, extending implementations MUST NOT override
     * <code>toJSON</code>, or MUST return the result of <code>super.toJSON()</code> as part of their
     * toJSON method.
     * <p>
     * @param child <ul><li>The matcher to apply these context changes to.</li></ul> This parameter is required.
     * @param contextModifiers <ul><li>a map of properties to add to the context object.</li></ul> This parameter is required.
     * @param currentRunModifiers <ul><li>a map of properties to add to the current run object.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected CascadingContextMatcher(final @org.jetbrains.annotations.NotNull java.lang.Object child, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> contextModifiers, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> currentRunModifiers) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { child, java.util.Objects.requireNonNull(contextModifiers, "contextModifiers is required"), java.util.Objects.requireNonNull(currentRunModifiers, "currentRunModifiers is required") });
    }

    /**
     * If extending this class, do not override this method (or if you do, make sure you call <code>super.toJSON()</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends io.contract_testing.contractcase.definitions.matchers.base.CascadingContextMatcher {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
