package io.contract_testing.contractcase.definitions.matchers.base;

/**
 * The base class for all Test Equivalence Matchers.
 * <p>
 * Extend this if you don't
 * have an example in your Matcher. Otherwise, use <code>AnyMatcherWithExample</code>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.458Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.base.AnyMatcher")
public abstract class AnyMatcher extends software.amazon.jsii.JsiiObject {

    protected AnyMatcher(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AnyMatcher(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The base class for all Test Equivalence Matchers.
     * <p>
     * Extend this if you don't
     * have an example in your Matcher. Otherwise, use {@link matchers.internals.AnyMatcherWithExample }
     * Matcher strings beginning with `_case:` are reserved for the default ContractCase
     * matchers.
     * Only use a types prefixed with `_case:` if you wish to create a special case
     * for a matching behaviour that is already provided by a core ContractCase matcher.
     * <p>
     * @param matcherType - The type string for this matcher (see {@link https://case.contract-testing.io/docs/reference/plugin-framework Extending ContractCase} for a description of these strings). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AnyMatcher(final @org.jetbrains.annotations.NotNull java.lang.String matcherType) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(matcherType, "matcherType is required") });
    }

    /**
     * Only override this method if you are writing a matcher in a language other than TypeScript.
     * <p>
     * It exists because the ContractCase matcher format is not legal in all languages that ContractCase supports.
     * WARNING: Do not return a string from this method. You must instead return
     * an object that can be serialised to JSON following the matcher format
     * described in {@link https://case.contract-testing.io/docs/reference/plugin-framework Extending ContractCase}.
     * <p>
     * @return An object in the matcher format described {@link https://case.contract-testing.io/docs/reference/plugin-framework in the Extending ContractCase documentation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends io.contract_testing.contractcase.definitions.matchers.base.AnyMatcher {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
