package io.contract_testing.contractcase.definitions.matchers.arrays;

/**
 * Options for the <code>ArrayLength</code> matcher.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.456Z")
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.arrays.ArrayLengthOptions")
@software.amazon.jsii.Jsii.Proxy(ArrayLengthOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ArrayLengthOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum length for the array - must be greater than minimum length.
     * <p>
     * Default infinity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLength() {
        return null;
    }

    /**
     * The minimum length for the array - must be greater than zero, otherwise empty arrays pass and you wouldn't be testing the array contents.
     * <p>
     * Default 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinLength() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ArrayLengthOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ArrayLengthOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ArrayLengthOptions> {
        java.lang.Number maxLength;
        java.lang.Number minLength;

        /**
         * Sets the value of {@link ArrayLengthOptions#getMaxLength}
         * @param maxLength The maximum length for the array - must be greater than minimum length.
         *                  Default infinity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLength(java.lang.Number maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        /**
         * Sets the value of {@link ArrayLengthOptions#getMinLength}
         * @param minLength The minimum length for the array - must be greater than zero, otherwise empty arrays pass and you wouldn't be testing the array contents.
         *                  Default 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLength(java.lang.Number minLength) {
            this.minLength = minLength;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ArrayLengthOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ArrayLengthOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ArrayLengthOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArrayLengthOptions {
        private final java.lang.Number maxLength;
        private final java.lang.Number minLength;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxLength = software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minLength = software.amazon.jsii.Kernel.get(this, "minLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxLength = builder.maxLength;
            this.minLength = builder.minLength;
        }

        @Override
        public final java.lang.Number getMaxLength() {
            return this.maxLength;
        }

        @Override
        public final java.lang.Number getMinLength() {
            return this.minLength;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxLength() != null) {
                data.set("maxLength", om.valueToTree(this.getMaxLength()));
            }
            if (this.getMinLength() != null) {
                data.set("minLength", om.valueToTree(this.getMinLength()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@contract-case/case-definition-dsl.matchers.arrays.ArrayLengthOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ArrayLengthOptions.Jsii$Proxy that = (ArrayLengthOptions.Jsii$Proxy) o;

            if (this.maxLength != null ? !this.maxLength.equals(that.maxLength) : that.maxLength != null) return false;
            return this.minLength != null ? this.minLength.equals(that.minLength) : that.minLength == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxLength != null ? this.maxLength.hashCode() : 0;
            result = 31 * result + (this.minLength != null ? this.minLength.hashCode() : 0);
            return result;
        }
    }
}
