package io.contract_testing.contractcase.definitions.matchers.arrays;

/**
 * Matches an Array whose length is within the specified range (or 1-infinity if not specified).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.456Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.matchers.arrays.ArrayLength")
public class ArrayLength extends io.contract_testing.contractcase.definitions.matchers.base.AnyMatcher {

    protected ArrayLength(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ArrayLength(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Matches an Array whose length is within the specified range (or 1-infinity if not specified).
     * <p>
     * @param options <ul><li>An <code>ArrayLengthOptions</code> object with optional minLength (default 1) and maxLength (default infinity) properties.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ArrayLength(final @org.jetbrains.annotations.NotNull io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLengthOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * For non-TypeScript implementations (see <code>AnyMatcher.toJSON</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A fluent builder for {@link io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLength}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLength> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLengthOptions.Builder options;

        private Builder() {
            this.options = new io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLengthOptions.Builder();
        }

        /**
         * The maximum length for the array - must be greater than minimum length.
         * <p>
         * Default infinity.
         * <p>
         * @return {@code this}
         * @param maxLength The maximum length for the array - must be greater than minimum length. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLength(final java.lang.Number maxLength) {
            this.options.maxLength(maxLength);
            return this;
        }

        /**
         * The minimum length for the array - must be greater than zero, otherwise empty arrays pass and you wouldn't be testing the array contents.
         * <p>
         * Default 1.
         * <p>
         * @return {@code this}
         * @param minLength The minimum length for the array - must be greater than zero, otherwise empty arrays pass and you wouldn't be testing the array contents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLength(final java.lang.Number minLength) {
            this.options.minLength(minLength);
            return this;
        }

        /**
         * @return a newly built instance of {@link io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLength}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLength build() {
            return new io.contract_testing.contractcase.definitions.matchers.arrays.ArrayLength(
                this.options.build()
            );
        }
    }
}
