package io.contract_testing.contractcase.definitions.interactions.base;

/**
 * This type defines the core behaviour that ContractCase has with this mock.
 * <p>
 * If you are using the included example types from ContractCase (or any
 * extension libraries), you do not need to use this class (or understand this
 * documentation).
 * <p>
 * This documentation is only necessary for people extending ContractCase to include
 * new mock types.
 * <p>
 * See the definitions in the case-entities-internal package for more details.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-10-26T12:15:02.438Z")
@software.amazon.jsii.Jsii(module = io.contract_testing.contractcase.definitions.$Module.class, fqn = "@contract-case/case-definition-dsl.interactions.base.ContractCaseCoreBehaviour")
@software.amazon.jsii.Jsii.Proxy(ContractCaseCoreBehaviour.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContractCaseCoreBehaviour extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of this mock.
     * <p>
     * Usually this is inverted on read vs write, for
     * example, a written MOCK_HTTP_CLIENT might become a MOCK_HTTP_SERVER during
     * reading.
     * <p>
     * This will almost always be the same as the top level type for your mock
     * during read - but if it is different, ContractCase will respect this value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMockType();

    /**
     * Whether or not this mock mode will invoke state handlers.
     * <p>
     * If set to
     * <code>"default"</code> then ContractCase will not invoke or require the state handlers
     * and will use the default values for all state variables. If set to <code>"state"</code>,
     * then ContractCase will invoke the state handlers and require the expected variables to
     * be returned.
     * <p>
     * All other values are errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStateVariables();

    /**
     * Whether or not this mock mode needs to be triggered by user-provided code.
     * <p>
     * If <code>"provided"</code> then ContractCase will require the user to provide a
     * trigger and a test function (eg, for testing an HTTP Client, code that will
     * invoke it must be provided). If <code>"generated"</code>, then ContractCase will not
     * require user provided triggers as it will generate them (eg, if the
     * system under test is an HTTP server, ContractCase will generate client calls).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTriggers();

    /**
     * @return a {@link Builder} of {@link ContractCaseCoreBehaviour}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContractCaseCoreBehaviour}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContractCaseCoreBehaviour> {
        java.lang.String mockType;
        java.lang.String stateVariables;
        java.lang.String triggers;

        /**
         * Sets the value of {@link ContractCaseCoreBehaviour#getMockType}
         * @param mockType The type of this mock. This parameter is required.
         *                 Usually this is inverted on read vs write, for
         *                 example, a written MOCK_HTTP_CLIENT might become a MOCK_HTTP_SERVER during
         *                 reading.
         *                 <p>
         *                 This will almost always be the same as the top level type for your mock
         *                 during read - but if it is different, ContractCase will respect this value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mockType(java.lang.String mockType) {
            this.mockType = mockType;
            return this;
        }

        /**
         * Sets the value of {@link ContractCaseCoreBehaviour#getStateVariables}
         * @param stateVariables Whether or not this mock mode will invoke state handlers. This parameter is required.
         *                       If set to
         *                       <code>"default"</code> then ContractCase will not invoke or require the state handlers
         *                       and will use the default values for all state variables. If set to <code>"state"</code>,
         *                       then ContractCase will invoke the state handlers and require the expected variables to
         *                       be returned.
         *                       <p>
         *                       All other values are errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateVariables(java.lang.String stateVariables) {
            this.stateVariables = stateVariables;
            return this;
        }

        /**
         * Sets the value of {@link ContractCaseCoreBehaviour#getTriggers}
         * @param triggers Whether or not this mock mode needs to be triggered by user-provided code. This parameter is required.
         *                 If <code>"provided"</code> then ContractCase will require the user to provide a
         *                 trigger and a test function (eg, for testing an HTTP Client, code that will
         *                 invoke it must be provided). If <code>"generated"</code>, then ContractCase will not
         *                 require user provided triggers as it will generate them (eg, if the
         *                 system under test is an HTTP server, ContractCase will generate client calls).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(java.lang.String triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContractCaseCoreBehaviour}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContractCaseCoreBehaviour build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContractCaseCoreBehaviour}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContractCaseCoreBehaviour {
        private final java.lang.String mockType;
        private final java.lang.String stateVariables;
        private final java.lang.String triggers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mockType = software.amazon.jsii.Kernel.get(this, "mockType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stateVariables = software.amazon.jsii.Kernel.get(this, "stateVariables", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.triggers = software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mockType = java.util.Objects.requireNonNull(builder.mockType, "mockType is required");
            this.stateVariables = java.util.Objects.requireNonNull(builder.stateVariables, "stateVariables is required");
            this.triggers = java.util.Objects.requireNonNull(builder.triggers, "triggers is required");
        }

        @Override
        public final java.lang.String getMockType() {
            return this.mockType;
        }

        @Override
        public final java.lang.String getStateVariables() {
            return this.stateVariables;
        }

        @Override
        public final java.lang.String getTriggers() {
            return this.triggers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mockType", om.valueToTree(this.getMockType()));
            data.set("stateVariables", om.valueToTree(this.getStateVariables()));
            data.set("triggers", om.valueToTree(this.getTriggers()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@contract-case/case-definition-dsl.interactions.base.ContractCaseCoreBehaviour"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContractCaseCoreBehaviour.Jsii$Proxy that = (ContractCaseCoreBehaviour.Jsii$Proxy) o;

            if (!mockType.equals(that.mockType)) return false;
            if (!stateVariables.equals(that.stateVariables)) return false;
            return this.triggers.equals(that.triggers);
        }

        @Override
        public final int hashCode() {
            int result = this.mockType.hashCode();
            result = 31 * result + (this.stateVariables.hashCode());
            result = 31 * result + (this.triggers.hashCode());
            return result;
        }
    }
}
